
const path = require('path');
const Database = require('../db');
const { format } = require('date-fns');
const multer = require('multer');
const crypto = require("crypto");
const { Activity_Log_Table } = require("../Database/Table_Names/TB_Name_Collection");

const db = new Database();

const successResponse = (res, message, data=null) => {
    res.status(200).json({
        statuscode: 200,
        error: false,
        message,
        data,
    });
}

const errorResponse = (res, StatusCode, message) => {
    res.status(StatusCode).json({
        statuscode: StatusCode,
        error: true,
        message,
        data: null,
    });
}

// execute Every Query Function
async function executeQuery(sql, params) {
    try {
        const result = await db.query(sql, params);

        if (!result) throw new Error("No result from database query");


        return result;
    } catch (err) {
        console.log("Error executing query", err);
        throw new Error(`Error executing query: ${err.message}`);
    }
}

// random id number
function generateRandomNumber(char) {
    const  randomNumber = Math.floor(Math.random() * 9000) + 100000;
  
    return `${char}${randomNumber}`
}

// date format
const formatted_date = format(new Date(), 'yyyy-MM-dd HH:mm:ss');

const filter_Old_New_Data = (oldValues, body) => {
    let old_value_log = { ...oldValues };
    let new_value_log = { };

    const changes = {};

    for (let key in body) {
      const oldValue = old_value_log[key] !== undefined ? old_value_log[key] : null;
      const newValue = body[key];

      if (oldValue != newValue) {
        changes[key] = oldValue;
        new_value_log[key] = newValue;
      }
    }

    return {changes, new_value_log};
}


// activity_log table
const activityLog = (activity_description, module_name, record_id, action, old_value, new_value) => {
    try {
        const sql = `INSERT INTO ${Activity_Log_Table} (activity_description, module_name, record_id, action, old_value, new_value,created_date) VALUES (?, ?, ?, ?, ?, ?, ?)`;
        const params = [activity_description, module_name, record_id, action, old_value, new_value, formatted_date];

        return executeQuery(sql, params);
    } catch (error) {
        throw error;
    }
}


const saveImage = () => {
    const uploadPath = path.join(__dirname, '../public/server_images/');

    const storage = multer.diskStorage({
        destination: (req, file, cb) => {
            cb(null, uploadPath);
        },
        filename: (req, file, cb) => {
            const ext = path.extname(file.originalname);
            const uniqueSuffix = Date.now() + '-' + crypto.randomBytes(8).toString('hex');
            cb(null, uniqueSuffix + ext);
        }
    });

    return storage;
}

const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
const mobileRegex = /^\d{10}$/;
// add validation of numbers, mobile number can't start from 0,1,2,3,4
// zip code must be of six numbers

module.exports =  {successResponse, errorResponse, executeQuery,generateRandomNumber, formatted_date, activityLog, filter_Old_New_Data, saveImage, emailRegex, mobileRegex };
