
const express = require("express");
const { errorResponse, successResponse } = require("../../utils/utils");
const state_data = require("../../Constants/states.json");

const router = express.Router();

async function getStateList(req,res) {
    try {
        let country_id = req.query.country_id;

        if(!country_id){
            return errorResponse(res,404,"Record not found");
        }

        const data = state_data
            .filter(state => state.country_id == country_id)
            .map(state => ({ id: state.id, name: state.name }));

        if (data.length === 0) {
            return errorResponse(res, 404, "No states found for the provided country_id");
        }

        successResponse(res, "State Details Fetched Successfully", data);
        
    } catch (error) {
        errorResponse(res,500,"Internal Server Error");
    }
}

router.get("/", getStateList)

module.exports = router;
