
const express = require('express');
const { successResponse, errorResponse } = require("../../utils/utils");
const country_data = require("../../Constants/countries.json");

const router = express.Router();

async function getCountryList(req,res) {
    try {
        const data = [];
        country_data.forEach(country => {
            data.push({id: country.id, name: country.name});
        })
        successResponse(res, "Country Details Fetched Successfully", data);
    } catch (error) {
        errorResponse(res,500,"Internal server error");
    }
}

router.get("/", getCountryList)

module.exports = router;
