
const express = require("express");
const { errorResponse, successResponse } = require("../../utils/utils");
const city_data = require("../../Constants/cities.json");

const router = express.Router();

async function getCityList(req,res) {
    try {
        let state_id = req.query.state_id;

        if(!state_id){
            return errorResponse(res,404,"Record not found");
        }

        const data = city_data
        .filter(city => city.state_id == state_id)
        .map(city => ({ id: city.id, name: city.name }));

        if (data.length === 0) {
            return errorResponse(res, 404, "No states found for the provided country_id");
        }

        successResponse(res, "City Details Fetched Successfully", data);

    } catch (error) {
        errorResponse(res,500,"Internal Server Error");
    }
}

router.get("/", getCityList);

module.exports = router;
