
const express = require('express');
const { createActivityLog, getAllActivityLogs } = require('../../models/Activity_Log/Activity_Log');
const { successResponse, errorResponse }  = require('../../utils/utils');

const router = express.Router();

async function CreateActivityLog(req, res) {
    try {
        const body = req.body;

        await createActivityLog( body.activity_description, body.module_name, body.record_id, body.action, body.created_by, body.created_date );

        successResponse(res,"Activity Log Created Successfully");

    } catch (error) {
        errorResponse(res,500,"Internal server error");
    }
}

async function GetAllActivityLogs(req, res) {
    try {
        const result = await getAllActivityLogs();

        successResponse(res,"Activity Logs Fetched Successfully", result);

    } catch (error) {
        errorResponse(res,500,"Internal server error");
    }
}

router.post("/", CreateActivityLog);
router.get("/", GetAllActivityLogs);

module.exports = router;
