const mysql = require('mysql2/promise');
require('dotenv').config();

class Database {
  constructor() {
    this.con = mysql.createPool({
      host: process.env.HOST,
      user: process.env.USER,
      password: process.env.PASSWORD,
      database: process.env.DATABASE,
      // port: process.env.DB_PORT,
    });
  }

  async testConnection() {
    try {
      await this.con.getConnection();
      console.log('Database connected successfully.');
    } catch (err) {
      console.error('Database connection failed:', err);
      throw new Error(`Unable to connect to database: ${err.message}`);
    }
  }

  async query(sql, params) {
    try {
      const [results] = await this.con.execute(sql, params);
      return results;
    } catch (err) {
      console.error("Database error:", err);
      throw new Error(`Query failed: ${err.message}`);
    }
  }
}

module.exports = Database;
