import {
  HostHeaderInputConfig,
  HostHeaderResolvedConfig,
} from "@aws-sdk/middleware-host-header";
import {
  UserAgentInputConfig,
  UserAgentResolvedConfig,
} from "@aws-sdk/middleware-user-agent";
import {
  RegionInputConfig,
  RegionResolvedConfig,
} from "@smithy/config-resolver";
import {
  EndpointInputConfig,
  EndpointResolvedConfig,
} from "@smithy/middleware-endpoint";
import {
  RetryInputConfig,
  RetryResolvedConfig,
} from "@smithy/middleware-retry";
import { HttpHandlerUserInput as __HttpHandlerUserInput } from "@smithy/protocol-http";
import {
  Client as __Client,
  DefaultsMode as __DefaultsMode,
  SmithyConfiguration as __SmithyConfiguration,
  SmithyResolvedConfiguration as __SmithyResolvedConfiguration,
} from "@smithy/smithy-client";
import {
  AwsCredentialIdentityProvider,
  BodyLengthCalculator as __BodyLengthCalculator,
  CheckOptionalClientConfig as __CheckOptionalClientConfig,
  ChecksumConstructor as __ChecksumConstructor,
  Decoder as __Decoder,
  Encoder as __Encoder,
  HashConstructor as __HashConstructor,
  HttpHandlerOptions as __HttpHandlerOptions,
  Logger as __Logger,
  Provider as __Provider,
  Provider,
  StreamCollector as __StreamCollector,
  UrlParser as __UrlParser,
  UserAgent as __UserAgent,
} from "@smithy/types";
import {
  HttpAuthSchemeInputConfig,
  HttpAuthSchemeResolvedConfig,
} from "./auth/httpAuthSchemeProvider";
import {
  AddCustomAttributesCommandInput,
  AddCustomAttributesCommandOutput,
} from "./commands/AddCustomAttributesCommand";
import {
  AdminAddUserToGroupCommandInput,
  AdminAddUserToGroupCommandOutput,
} from "./commands/AdminAddUserToGroupCommand";
import {
  AdminConfirmSignUpCommandInput,
  AdminConfirmSignUpCommandOutput,
} from "./commands/AdminConfirmSignUpCommand";
import {
  AdminCreateUserCommandInput,
  AdminCreateUserCommandOutput,
} from "./commands/AdminCreateUserCommand";
import {
  AdminDeleteUserAttributesCommandInput,
  AdminDeleteUserAttributesCommandOutput,
} from "./commands/AdminDeleteUserAttributesCommand";
import {
  AdminDeleteUserCommandInput,
  AdminDeleteUserCommandOutput,
} from "./commands/AdminDeleteUserCommand";
import {
  AdminDisableProviderForUserCommandInput,
  AdminDisableProviderForUserCommandOutput,
} from "./commands/AdminDisableProviderForUserCommand";
import {
  AdminDisableUserCommandInput,
  AdminDisableUserCommandOutput,
} from "./commands/AdminDisableUserCommand";
import {
  AdminEnableUserCommandInput,
  AdminEnableUserCommandOutput,
} from "./commands/AdminEnableUserCommand";
import {
  AdminForgetDeviceCommandInput,
  AdminForgetDeviceCommandOutput,
} from "./commands/AdminForgetDeviceCommand";
import {
  AdminGetDeviceCommandInput,
  AdminGetDeviceCommandOutput,
} from "./commands/AdminGetDeviceCommand";
import {
  AdminGetUserCommandInput,
  AdminGetUserCommandOutput,
} from "./commands/AdminGetUserCommand";
import {
  AdminInitiateAuthCommandInput,
  AdminInitiateAuthCommandOutput,
} from "./commands/AdminInitiateAuthCommand";
import {
  AdminLinkProviderForUserCommandInput,
  AdminLinkProviderForUserCommandOutput,
} from "./commands/AdminLinkProviderForUserCommand";
import {
  AdminListDevicesCommandInput,
  AdminListDevicesCommandOutput,
} from "./commands/AdminListDevicesCommand";
import {
  AdminListGroupsForUserCommandInput,
  AdminListGroupsForUserCommandOutput,
} from "./commands/AdminListGroupsForUserCommand";
import {
  AdminListUserAuthEventsCommandInput,
  AdminListUserAuthEventsCommandOutput,
} from "./commands/AdminListUserAuthEventsCommand";
import {
  AdminRemoveUserFromGroupCommandInput,
  AdminRemoveUserFromGroupCommandOutput,
} from "./commands/AdminRemoveUserFromGroupCommand";
import {
  AdminResetUserPasswordCommandInput,
  AdminResetUserPasswordCommandOutput,
} from "./commands/AdminResetUserPasswordCommand";
import {
  AdminRespondToAuthChallengeCommandInput,
  AdminRespondToAuthChallengeCommandOutput,
} from "./commands/AdminRespondToAuthChallengeCommand";
import {
  AdminSetUserMFAPreferenceCommandInput,
  AdminSetUserMFAPreferenceCommandOutput,
} from "./commands/AdminSetUserMFAPreferenceCommand";
import {
  AdminSetUserPasswordCommandInput,
  AdminSetUserPasswordCommandOutput,
} from "./commands/AdminSetUserPasswordCommand";
import {
  AdminSetUserSettingsCommandInput,
  AdminSetUserSettingsCommandOutput,
} from "./commands/AdminSetUserSettingsCommand";
import {
  AdminUpdateAuthEventFeedbackCommandInput,
  AdminUpdateAuthEventFeedbackCommandOutput,
} from "./commands/AdminUpdateAuthEventFeedbackCommand";
import {
  AdminUpdateDeviceStatusCommandInput,
  AdminUpdateDeviceStatusCommandOutput,
} from "./commands/AdminUpdateDeviceStatusCommand";
import {
  AdminUpdateUserAttributesCommandInput,
  AdminUpdateUserAttributesCommandOutput,
} from "./commands/AdminUpdateUserAttributesCommand";
import {
  AdminUserGlobalSignOutCommandInput,
  AdminUserGlobalSignOutCommandOutput,
} from "./commands/AdminUserGlobalSignOutCommand";
import {
  AssociateSoftwareTokenCommandInput,
  AssociateSoftwareTokenCommandOutput,
} from "./commands/AssociateSoftwareTokenCommand";
import {
  ChangePasswordCommandInput,
  ChangePasswordCommandOutput,
} from "./commands/ChangePasswordCommand";
import {
  ConfirmDeviceCommandInput,
  ConfirmDeviceCommandOutput,
} from "./commands/ConfirmDeviceCommand";
import {
  ConfirmForgotPasswordCommandInput,
  ConfirmForgotPasswordCommandOutput,
} from "./commands/ConfirmForgotPasswordCommand";
import {
  ConfirmSignUpCommandInput,
  ConfirmSignUpCommandOutput,
} from "./commands/ConfirmSignUpCommand";
import {
  CreateGroupCommandInput,
  CreateGroupCommandOutput,
} from "./commands/CreateGroupCommand";
import {
  CreateIdentityProviderCommandInput,
  CreateIdentityProviderCommandOutput,
} from "./commands/CreateIdentityProviderCommand";
import {
  CreateResourceServerCommandInput,
  CreateResourceServerCommandOutput,
} from "./commands/CreateResourceServerCommand";
import {
  CreateUserImportJobCommandInput,
  CreateUserImportJobCommandOutput,
} from "./commands/CreateUserImportJobCommand";
import {
  CreateUserPoolClientCommandInput,
  CreateUserPoolClientCommandOutput,
} from "./commands/CreateUserPoolClientCommand";
import {
  CreateUserPoolCommandInput,
  CreateUserPoolCommandOutput,
} from "./commands/CreateUserPoolCommand";
import {
  CreateUserPoolDomainCommandInput,
  CreateUserPoolDomainCommandOutput,
} from "./commands/CreateUserPoolDomainCommand";
import {
  DeleteGroupCommandInput,
  DeleteGroupCommandOutput,
} from "./commands/DeleteGroupCommand";
import {
  DeleteIdentityProviderCommandInput,
  DeleteIdentityProviderCommandOutput,
} from "./commands/DeleteIdentityProviderCommand";
import {
  DeleteResourceServerCommandInput,
  DeleteResourceServerCommandOutput,
} from "./commands/DeleteResourceServerCommand";
import {
  DeleteUserAttributesCommandInput,
  DeleteUserAttributesCommandOutput,
} from "./commands/DeleteUserAttributesCommand";
import {
  DeleteUserCommandInput,
  DeleteUserCommandOutput,
} from "./commands/DeleteUserCommand";
import {
  DeleteUserPoolClientCommandInput,
  DeleteUserPoolClientCommandOutput,
} from "./commands/DeleteUserPoolClientCommand";
import {
  DeleteUserPoolCommandInput,
  DeleteUserPoolCommandOutput,
} from "./commands/DeleteUserPoolCommand";
import {
  DeleteUserPoolDomainCommandInput,
  DeleteUserPoolDomainCommandOutput,
} from "./commands/DeleteUserPoolDomainCommand";
import {
  DescribeIdentityProviderCommandInput,
  DescribeIdentityProviderCommandOutput,
} from "./commands/DescribeIdentityProviderCommand";
import {
  DescribeResourceServerCommandInput,
  DescribeResourceServerCommandOutput,
} from "./commands/DescribeResourceServerCommand";
import {
  DescribeRiskConfigurationCommandInput,
  DescribeRiskConfigurationCommandOutput,
} from "./commands/DescribeRiskConfigurationCommand";
import {
  DescribeUserImportJobCommandInput,
  DescribeUserImportJobCommandOutput,
} from "./commands/DescribeUserImportJobCommand";
import {
  DescribeUserPoolClientCommandInput,
  DescribeUserPoolClientCommandOutput,
} from "./commands/DescribeUserPoolClientCommand";
import {
  DescribeUserPoolCommandInput,
  DescribeUserPoolCommandOutput,
} from "./commands/DescribeUserPoolCommand";
import {
  DescribeUserPoolDomainCommandInput,
  DescribeUserPoolDomainCommandOutput,
} from "./commands/DescribeUserPoolDomainCommand";
import {
  ForgetDeviceCommandInput,
  ForgetDeviceCommandOutput,
} from "./commands/ForgetDeviceCommand";
import {
  ForgotPasswordCommandInput,
  ForgotPasswordCommandOutput,
} from "./commands/ForgotPasswordCommand";
import {
  GetCSVHeaderCommandInput,
  GetCSVHeaderCommandOutput,
} from "./commands/GetCSVHeaderCommand";
import {
  GetDeviceCommandInput,
  GetDeviceCommandOutput,
} from "./commands/GetDeviceCommand";
import {
  GetGroupCommandInput,
  GetGroupCommandOutput,
} from "./commands/GetGroupCommand";
import {
  GetIdentityProviderByIdentifierCommandInput,
  GetIdentityProviderByIdentifierCommandOutput,
} from "./commands/GetIdentityProviderByIdentifierCommand";
import {
  GetLogDeliveryConfigurationCommandInput,
  GetLogDeliveryConfigurationCommandOutput,
} from "./commands/GetLogDeliveryConfigurationCommand";
import {
  GetSigningCertificateCommandInput,
  GetSigningCertificateCommandOutput,
} from "./commands/GetSigningCertificateCommand";
import {
  GetUICustomizationCommandInput,
  GetUICustomizationCommandOutput,
} from "./commands/GetUICustomizationCommand";
import {
  GetUserAttributeVerificationCodeCommandInput,
  GetUserAttributeVerificationCodeCommandOutput,
} from "./commands/GetUserAttributeVerificationCodeCommand";
import {
  GetUserCommandInput,
  GetUserCommandOutput,
} from "./commands/GetUserCommand";
import {
  GetUserPoolMfaConfigCommandInput,
  GetUserPoolMfaConfigCommandOutput,
} from "./commands/GetUserPoolMfaConfigCommand";
import {
  GlobalSignOutCommandInput,
  GlobalSignOutCommandOutput,
} from "./commands/GlobalSignOutCommand";
import {
  InitiateAuthCommandInput,
  InitiateAuthCommandOutput,
} from "./commands/InitiateAuthCommand";
import {
  ListDevicesCommandInput,
  ListDevicesCommandOutput,
} from "./commands/ListDevicesCommand";
import {
  ListGroupsCommandInput,
  ListGroupsCommandOutput,
} from "./commands/ListGroupsCommand";
import {
  ListIdentityProvidersCommandInput,
  ListIdentityProvidersCommandOutput,
} from "./commands/ListIdentityProvidersCommand";
import {
  ListResourceServersCommandInput,
  ListResourceServersCommandOutput,
} from "./commands/ListResourceServersCommand";
import {
  ListTagsForResourceCommandInput,
  ListTagsForResourceCommandOutput,
} from "./commands/ListTagsForResourceCommand";
import {
  ListUserImportJobsCommandInput,
  ListUserImportJobsCommandOutput,
} from "./commands/ListUserImportJobsCommand";
import {
  ListUserPoolClientsCommandInput,
  ListUserPoolClientsCommandOutput,
} from "./commands/ListUserPoolClientsCommand";
import {
  ListUserPoolsCommandInput,
  ListUserPoolsCommandOutput,
} from "./commands/ListUserPoolsCommand";
import {
  ListUsersCommandInput,
  ListUsersCommandOutput,
} from "./commands/ListUsersCommand";
import {
  ListUsersInGroupCommandInput,
  ListUsersInGroupCommandOutput,
} from "./commands/ListUsersInGroupCommand";
import {
  ResendConfirmationCodeCommandInput,
  ResendConfirmationCodeCommandOutput,
} from "./commands/ResendConfirmationCodeCommand";
import {
  RespondToAuthChallengeCommandInput,
  RespondToAuthChallengeCommandOutput,
} from "./commands/RespondToAuthChallengeCommand";
import {
  RevokeTokenCommandInput,
  RevokeTokenCommandOutput,
} from "./commands/RevokeTokenCommand";
import {
  SetLogDeliveryConfigurationCommandInput,
  SetLogDeliveryConfigurationCommandOutput,
} from "./commands/SetLogDeliveryConfigurationCommand";
import {
  SetRiskConfigurationCommandInput,
  SetRiskConfigurationCommandOutput,
} from "./commands/SetRiskConfigurationCommand";
import {
  SetUICustomizationCommandInput,
  SetUICustomizationCommandOutput,
} from "./commands/SetUICustomizationCommand";
import {
  SetUserMFAPreferenceCommandInput,
  SetUserMFAPreferenceCommandOutput,
} from "./commands/SetUserMFAPreferenceCommand";
import {
  SetUserPoolMfaConfigCommandInput,
  SetUserPoolMfaConfigCommandOutput,
} from "./commands/SetUserPoolMfaConfigCommand";
import {
  SetUserSettingsCommandInput,
  SetUserSettingsCommandOutput,
} from "./commands/SetUserSettingsCommand";
import {
  SignUpCommandInput,
  SignUpCommandOutput,
} from "./commands/SignUpCommand";
import {
  StartUserImportJobCommandInput,
  StartUserImportJobCommandOutput,
} from "./commands/StartUserImportJobCommand";
import {
  StopUserImportJobCommandInput,
  StopUserImportJobCommandOutput,
} from "./commands/StopUserImportJobCommand";
import {
  TagResourceCommandInput,
  TagResourceCommandOutput,
} from "./commands/TagResourceCommand";
import {
  UntagResourceCommandInput,
  UntagResourceCommandOutput,
} from "./commands/UntagResourceCommand";
import {
  UpdateAuthEventFeedbackCommandInput,
  UpdateAuthEventFeedbackCommandOutput,
} from "./commands/UpdateAuthEventFeedbackCommand";
import {
  UpdateDeviceStatusCommandInput,
  UpdateDeviceStatusCommandOutput,
} from "./commands/UpdateDeviceStatusCommand";
import {
  UpdateGroupCommandInput,
  UpdateGroupCommandOutput,
} from "./commands/UpdateGroupCommand";
import {
  UpdateIdentityProviderCommandInput,
  UpdateIdentityProviderCommandOutput,
} from "./commands/UpdateIdentityProviderCommand";
import {
  UpdateResourceServerCommandInput,
  UpdateResourceServerCommandOutput,
} from "./commands/UpdateResourceServerCommand";
import {
  UpdateUserAttributesCommandInput,
  UpdateUserAttributesCommandOutput,
} from "./commands/UpdateUserAttributesCommand";
import {
  UpdateUserPoolClientCommandInput,
  UpdateUserPoolClientCommandOutput,
} from "./commands/UpdateUserPoolClientCommand";
import {
  UpdateUserPoolCommandInput,
  UpdateUserPoolCommandOutput,
} from "./commands/UpdateUserPoolCommand";
import {
  UpdateUserPoolDomainCommandInput,
  UpdateUserPoolDomainCommandOutput,
} from "./commands/UpdateUserPoolDomainCommand";
import {
  VerifySoftwareTokenCommandInput,
  VerifySoftwareTokenCommandOutput,
} from "./commands/VerifySoftwareTokenCommand";
import {
  VerifyUserAttributeCommandInput,
  VerifyUserAttributeCommandOutput,
} from "./commands/VerifyUserAttributeCommand";
import {
  ClientInputEndpointParameters,
  ClientResolvedEndpointParameters,
  EndpointParameters,
} from "./endpoint/EndpointParameters";
import { RuntimeExtension, RuntimeExtensionsConfig } from "./runtimeExtensions";
export { __Client };
export type ServiceInputTypes =
  | AddCustomAttributesCommandInput
  | AdminAddUserToGroupCommandInput
  | AdminConfirmSignUpCommandInput
  | AdminCreateUserCommandInput
  | AdminDeleteUserAttributesCommandInput
  | AdminDeleteUserCommandInput
  | AdminDisableProviderForUserCommandInput
  | AdminDisableUserCommandInput
  | AdminEnableUserCommandInput
  | AdminForgetDeviceCommandInput
  | AdminGetDeviceCommandInput
  | AdminGetUserCommandInput
  | AdminInitiateAuthCommandInput
  | AdminLinkProviderForUserCommandInput
  | AdminListDevicesCommandInput
  | AdminListGroupsForUserCommandInput
  | AdminListUserAuthEventsCommandInput
  | AdminRemoveUserFromGroupCommandInput
  | AdminResetUserPasswordCommandInput
  | AdminRespondToAuthChallengeCommandInput
  | AdminSetUserMFAPreferenceCommandInput
  | AdminSetUserPasswordCommandInput
  | AdminSetUserSettingsCommandInput
  | AdminUpdateAuthEventFeedbackCommandInput
  | AdminUpdateDeviceStatusCommandInput
  | AdminUpdateUserAttributesCommandInput
  | AdminUserGlobalSignOutCommandInput
  | AssociateSoftwareTokenCommandInput
  | ChangePasswordCommandInput
  | ConfirmDeviceCommandInput
  | ConfirmForgotPasswordCommandInput
  | ConfirmSignUpCommandInput
  | CreateGroupCommandInput
  | CreateIdentityProviderCommandInput
  | CreateResourceServerCommandInput
  | CreateUserImportJobCommandInput
  | CreateUserPoolClientCommandInput
  | CreateUserPoolCommandInput
  | CreateUserPoolDomainCommandInput
  | DeleteGroupCommandInput
  | DeleteIdentityProviderCommandInput
  | DeleteResourceServerCommandInput
  | DeleteUserAttributesCommandInput
  | DeleteUserCommandInput
  | DeleteUserPoolClientCommandInput
  | DeleteUserPoolCommandInput
  | DeleteUserPoolDomainCommandInput
  | DescribeIdentityProviderCommandInput
  | DescribeResourceServerCommandInput
  | DescribeRiskConfigurationCommandInput
  | DescribeUserImportJobCommandInput
  | DescribeUserPoolClientCommandInput
  | DescribeUserPoolCommandInput
  | DescribeUserPoolDomainCommandInput
  | ForgetDeviceCommandInput
  | ForgotPasswordCommandInput
  | GetCSVHeaderCommandInput
  | GetDeviceCommandInput
  | GetGroupCommandInput
  | GetIdentityProviderByIdentifierCommandInput
  | GetLogDeliveryConfigurationCommandInput
  | GetSigningCertificateCommandInput
  | GetUICustomizationCommandInput
  | GetUserAttributeVerificationCodeCommandInput
  | GetUserCommandInput
  | GetUserPoolMfaConfigCommandInput
  | GlobalSignOutCommandInput
  | InitiateAuthCommandInput
  | ListDevicesCommandInput
  | ListGroupsCommandInput
  | ListIdentityProvidersCommandInput
  | ListResourceServersCommandInput
  | ListTagsForResourceCommandInput
  | ListUserImportJobsCommandInput
  | ListUserPoolClientsCommandInput
  | ListUserPoolsCommandInput
  | ListUsersCommandInput
  | ListUsersInGroupCommandInput
  | ResendConfirmationCodeCommandInput
  | RespondToAuthChallengeCommandInput
  | RevokeTokenCommandInput
  | SetLogDeliveryConfigurationCommandInput
  | SetRiskConfigurationCommandInput
  | SetUICustomizationCommandInput
  | SetUserMFAPreferenceCommandInput
  | SetUserPoolMfaConfigCommandInput
  | SetUserSettingsCommandInput
  | SignUpCommandInput
  | StartUserImportJobCommandInput
  | StopUserImportJobCommandInput
  | TagResourceCommandInput
  | UntagResourceCommandInput
  | UpdateAuthEventFeedbackCommandInput
  | UpdateDeviceStatusCommandInput
  | UpdateGroupCommandInput
  | UpdateIdentityProviderCommandInput
  | UpdateResourceServerCommandInput
  | UpdateUserAttributesCommandInput
  | UpdateUserPoolClientCommandInput
  | UpdateUserPoolCommandInput
  | UpdateUserPoolDomainCommandInput
  | VerifySoftwareTokenCommandInput
  | VerifyUserAttributeCommandInput;
export type ServiceOutputTypes =
  | AddCustomAttributesCommandOutput
  | AdminAddUserToGroupCommandOutput
  | AdminConfirmSignUpCommandOutput
  | AdminCreateUserCommandOutput
  | AdminDeleteUserAttributesCommandOutput
  | AdminDeleteUserCommandOutput
  | AdminDisableProviderForUserCommandOutput
  | AdminDisableUserCommandOutput
  | AdminEnableUserCommandOutput
  | AdminForgetDeviceCommandOutput
  | AdminGetDeviceCommandOutput
  | AdminGetUserCommandOutput
  | AdminInitiateAuthCommandOutput
  | AdminLinkProviderForUserCommandOutput
  | AdminListDevicesCommandOutput
  | AdminListGroupsForUserCommandOutput
  | AdminListUserAuthEventsCommandOutput
  | AdminRemoveUserFromGroupCommandOutput
  | AdminResetUserPasswordCommandOutput
  | AdminRespondToAuthChallengeCommandOutput
  | AdminSetUserMFAPreferenceCommandOutput
  | AdminSetUserPasswordCommandOutput
  | AdminSetUserSettingsCommandOutput
  | AdminUpdateAuthEventFeedbackCommandOutput
  | AdminUpdateDeviceStatusCommandOutput
  | AdminUpdateUserAttributesCommandOutput
  | AdminUserGlobalSignOutCommandOutput
  | AssociateSoftwareTokenCommandOutput
  | ChangePasswordCommandOutput
  | ConfirmDeviceCommandOutput
  | ConfirmForgotPasswordCommandOutput
  | ConfirmSignUpCommandOutput
  | CreateGroupCommandOutput
  | CreateIdentityProviderCommandOutput
  | CreateResourceServerCommandOutput
  | CreateUserImportJobCommandOutput
  | CreateUserPoolClientCommandOutput
  | CreateUserPoolCommandOutput
  | CreateUserPoolDomainCommandOutput
  | DeleteGroupCommandOutput
  | DeleteIdentityProviderCommandOutput
  | DeleteResourceServerCommandOutput
  | DeleteUserAttributesCommandOutput
  | DeleteUserCommandOutput
  | DeleteUserPoolClientCommandOutput
  | DeleteUserPoolCommandOutput
  | DeleteUserPoolDomainCommandOutput
  | DescribeIdentityProviderCommandOutput
  | DescribeResourceServerCommandOutput
  | DescribeRiskConfigurationCommandOutput
  | DescribeUserImportJobCommandOutput
  | DescribeUserPoolClientCommandOutput
  | DescribeUserPoolCommandOutput
  | DescribeUserPoolDomainCommandOutput
  | ForgetDeviceCommandOutput
  | ForgotPasswordCommandOutput
  | GetCSVHeaderCommandOutput
  | GetDeviceCommandOutput
  | GetGroupCommandOutput
  | GetIdentityProviderByIdentifierCommandOutput
  | GetLogDeliveryConfigurationCommandOutput
  | GetSigningCertificateCommandOutput
  | GetUICustomizationCommandOutput
  | GetUserAttributeVerificationCodeCommandOutput
  | GetUserCommandOutput
  | GetUserPoolMfaConfigCommandOutput
  | GlobalSignOutCommandOutput
  | InitiateAuthCommandOutput
  | ListDevicesCommandOutput
  | ListGroupsCommandOutput
  | ListIdentityProvidersCommandOutput
  | ListResourceServersCommandOutput
  | ListTagsForResourceCommandOutput
  | ListUserImportJobsCommandOutput
  | ListUserPoolClientsCommandOutput
  | ListUserPoolsCommandOutput
  | ListUsersCommandOutput
  | ListUsersInGroupCommandOutput
  | ResendConfirmationCodeCommandOutput
  | RespondToAuthChallengeCommandOutput
  | RevokeTokenCommandOutput
  | SetLogDeliveryConfigurationCommandOutput
  | SetRiskConfigurationCommandOutput
  | SetUICustomizationCommandOutput
  | SetUserMFAPreferenceCommandOutput
  | SetUserPoolMfaConfigCommandOutput
  | SetUserSettingsCommandOutput
  | SignUpCommandOutput
  | StartUserImportJobCommandOutput
  | StopUserImportJobCommandOutput
  | TagResourceCommandOutput
  | UntagResourceCommandOutput
  | UpdateAuthEventFeedbackCommandOutput
  | UpdateDeviceStatusCommandOutput
  | UpdateGroupCommandOutput
  | UpdateIdentityProviderCommandOutput
  | UpdateResourceServerCommandOutput
  | UpdateUserAttributesCommandOutput
  | UpdateUserPoolClientCommandOutput
  | UpdateUserPoolCommandOutput
  | UpdateUserPoolDomainCommandOutput
  | VerifySoftwareTokenCommandOutput
  | VerifyUserAttributeCommandOutput;
export interface ClientDefaults
  extends Partial<__SmithyConfiguration<__HttpHandlerOptions>> {
  requestHandler?: __HttpHandlerUserInput;
  sha256?: __ChecksumConstructor | __HashConstructor;
  urlParser?: __UrlParser;
  bodyLengthChecker?: __BodyLengthCalculator;
  streamCollector?: __StreamCollector;
  base64Decoder?: __Decoder;
  base64Encoder?: __Encoder;
  utf8Decoder?: __Decoder;
  utf8Encoder?: __Encoder;
  runtime?: string;
  disableHostPrefix?: boolean;
  serviceId?: string;
  useDualstackEndpoint?: boolean | __Provider<boolean>;
  useFipsEndpoint?: boolean | __Provider<boolean>;
  region?: string | __Provider<string>;
  defaultUserAgentProvider?: Provider<__UserAgent>;
  credentialDefaultProvider?: (input: any) => AwsCredentialIdentityProvider;
  maxAttempts?: number | __Provider<number>;
  retryMode?: string | __Provider<string>;
  logger?: __Logger;
  extensions?: RuntimeExtension[];
  defaultsMode?: __DefaultsMode | __Provider<__DefaultsMode>;
}
export type CognitoIdentityProviderClientConfigType = Partial<
  __SmithyConfiguration<__HttpHandlerOptions>
> &
  ClientDefaults &
  UserAgentInputConfig &
  RetryInputConfig &
  RegionInputConfig &
  HostHeaderInputConfig &
  EndpointInputConfig<EndpointParameters> &
  HttpAuthSchemeInputConfig &
  ClientInputEndpointParameters;
export interface CognitoIdentityProviderClientConfig
  extends CognitoIdentityProviderClientConfigType {}
export type CognitoIdentityProviderClientResolvedConfigType =
  __SmithyResolvedConfiguration<__HttpHandlerOptions> &
    Required<ClientDefaults> &
    RuntimeExtensionsConfig &
    UserAgentResolvedConfig &
    RetryResolvedConfig &
    RegionResolvedConfig &
    HostHeaderResolvedConfig &
    EndpointResolvedConfig<EndpointParameters> &
    HttpAuthSchemeResolvedConfig &
    ClientResolvedEndpointParameters;
export interface CognitoIdentityProviderClientResolvedConfig
  extends CognitoIdentityProviderClientResolvedConfigType {}
export declare class CognitoIdentityProviderClient extends __Client<
  __HttpHandlerOptions,
  ServiceInputTypes,
  ServiceOutputTypes,
  CognitoIdentityProviderClientResolvedConfig
> {
  readonly config: CognitoIdentityProviderClientResolvedConfig;
  constructor(
    ...[
      configuration,
    ]: __CheckOptionalClientConfig<CognitoIdentityProviderClientConfig>
  );
  destroy(): void;
}
