
const { executeQuery } = require("../../utils/utils");
const { Users_Table } = require("../../Database/Table_Names/TB_Name_Collection");

function createUser(user_id, first_name, last_name, picture, country, state, city, street_1, street_2, zip_code, email, dial_code, mobile, user_role, status, created_date) {
  const sql = `INSERT INTO ${Users_Table}(user_id, first_name, last_name, picture, country, state, city, street_1, street_2, zip_code, email, dial_code,  mobile, user_role, status, created_date) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`;
  const params = [user_id, first_name, last_name, picture, country, state, city, street_1, street_2, zip_code, email, dial_code, mobile, user_role, status, created_date];

  return executeQuery(sql, params);
}

function updateUser(first_name, last_name, picture, country, state, city, street_1, street_2, zip_code, email, dial_code, mobile, user_role, status, updated_date, user_id) {
  const sql = `UPDATE ${Users_Table} SET first_name = ?, last_name = ?, ${picture && "picture = ?,"} country = ?, state = ?, city = ?, street_1 = ?, street_2 = ?, zip_code = ?, email = ?, dial_code = ?, mobile = ?, user_role = ?, status = ?, updated_date = ? WHERE user_id = ? AND is_deleted <> 1`;

  const params = picture == "" ?
    [first_name, last_name, country, state, city, street_1, street_2, zip_code, email, mobile, user_role, status, updated_date, user_id]
    : [first_name, last_name, picture, country, state, city, street_1, street_2, zip_code, email, dial_code, mobile, user_role, status, updated_date, user_id];

  return executeQuery(sql, params);
}

function getAllUsers(current_page, per_page, search_text) {
  const offset = (current_page - 1) * per_page;
  const sql = `SELECT user_id, CONCAT(first_name, ' ', last_name) AS full_name, picture, email, dial_code, mobile, status, user_role FROM ${Users_Table} WHERE CONCAT(first_name, last_name, email, mobile) LIKE '%${search_text.replace(/'/g, "''")}%' AND is_deleted <> 1 ORDER BY created_date ASC LIMIT ${per_page} OFFSET ${offset}`;

  return executeQuery(sql, []);
}

function getTotalUsers(search_text) {
  const sql = `SELECT COUNT(*) AS total FROM ${Users_Table} WHERE CONCAT(first_name, last_name, email, mobile, status, user_role) LIKE '%${search_text.replace(/'/g, "''")}%' AND is_deleted <> 1`;
  
  return executeQuery(sql, []);
}

function getUserById(user_id) {
  const sql = `SELECT user_id, first_name, last_name, picture, country, state, city, street_1, street_2, zip_code, email, dial_code, mobile, status, user_role FROM ${Users_Table} WHERE user_id = ? AND is_deleted <> 1`;
  const params = [user_id];

  return executeQuery(sql, params);
}

function getUserInfo(user_id) {
  const sql = `SELECT user_id, CONCAT(first_name, ' ', last_name) AS full_name, picture, country, state, city, street_1, street_2, zip_code, email, dial_code, mobile, status, user_role FROM ${Users_Table} WHERE user_id = ? AND is_deleted <> 1`;
  const params = [user_id];

  return executeQuery(sql, params);
}

function deleteUser(user_id) {
  const sql = `UPDATE ${Users_Table} SET is_deleted = ? WHERE user_id = ? AND is_deleted <> 1`;
  const params = [1, user_id];

  return executeQuery(sql, params);
}

function UpdateAssignedApp(assigned_apps, user_id) {
  const sql =  `UPDATE ${Users_Table} SET assigned_apps = ? WHERE user_id = ? AND is_deleted <> 1`;
  const params = [assigned_apps, user_id];

  return executeQuery(sql,params)
}

module.exports = { createUser, updateUser, getAllUsers, getUserById, deleteUser, getUserInfo, getTotalUsers, UpdateAssignedApp };


// id user_id first_name last_name picture country state city zip_code street_1 street_2 email mobile 
