
const database = require('../../db');
const db = new database();
const { Users_Table, Activity_Log_Table, Apps_Table, User_Role_Table, Login_Table } = require("../Table_Names/TB_Name_Collection");

const queries = [
    // users
    `CREATE TABLE IF NOT EXISTS ${Users_Table} (
        id INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
        user_id VARCHAR(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
        first_name VARCHAR(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
        last_name VARCHAR(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
        picture VARCHAR(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
        country INT(10) NOT NULL,
        state INT(10) NOT NULL,
        city INT(10) NOT NULL,
        street_1 VARCHAR(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
        street_2 VARCHAR(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
        zip_code INT(10) NOT NULL,
        email VARCHAR(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
        dial_code VARCHAR(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
        mobile BIGINT(20) NOT NULL,
        user_role INT(1) NOT NULL DEFAULT 0,
        status INT(1) NOT NULL DEFAULT 0,
        created_by VARCHAR(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
        created_date DATETIME NOT NULL,
        updated_by VARCHAR(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
        updated_date DATETIME NOT NULL,
        is_deleted INT(1) NOT NULL DEFAULT 0
    );`,

    // activity_log
    `CREATE TABLE IF NOT EXISTS ${Activity_Log_Table} (
        id INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
        activity_description LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL,
        module_name VARCHAR(100) COLLATE utf8mb4_general_ci NOT NULL,
        record_id VARCHAR(100) COLLATE utf8mb4_general_ci NOT NULL,
        action VARCHAR(20) COLLATE utf8mb4_general_ci NOT NULL,
        old_value LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL,
        new_value LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NULL,
        created_by INT (11) NOT NULL,
        created_date DATETIME NOT NULL
    );`,

    // apps
    `CREATE TABLE IF NOT EXISTS ${Apps_Table} (
        id INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
        app_id VARCHAR(10) COLLATE utf8mb4_general_ci NOT NULL,
        picture VARCHAR(200) COLLATE utf8mb4_general_ci NOT NULL,
        name VARCHAR(100) COLLATE utf8mb4_general_ci NOT NULL,
        app_url VARCHAR(100) COLLATE utf8mb4_general_ci NOT NULL,
        app_description VARCHAR(500) COLLATE utf8mb4_general_ci NOT NULL,
        status INT(1) NOT NULL DEFAULT 0,
        created_by VARCHAR(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
        created_date DATETIME NOT NULL,
        updated_by VARCHAR(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
        updated_date DATETIME NOT NULL,
        is_deleted INT(1) NOT NULL DEFAULT 0
    );`,

    // user_role
    `CREATE TABLE IF NOT EXISTS ${User_Role_Table} (
        id INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
        role_name VARCHAR(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
        permissions LONGTEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
        is_deleted INT(1) NOT NULL DEFAULT 0
    );`,

    // trial
    `CREATE TABLE IF NOT EXISTS ${Login_Table} (
        id INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
        username VARCHAR(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
        access_token LONGTEXT COLLATE utf8mb4_general_ci DEFAULT NULL,
        refresh_token LONGTEXT COLLATE utf8mb4_general_ci DEFAULT NULL,
        is_login INT(1) NOT NULL DEFAULT 0,
        KEY username (username)
    );`,
];

const runQueries = async () => {
    try {
        for (const query of queries) {
            await db.query(query);
            // console.log('Table created/exists');
        }
        return 'Database setup completed successfully.';
    } catch (error) {
        console.error('Error executing queries:', error);
        throw new Error(`Error creating tables: ${error.message}`);
    }
};

module.exports = runQueries;
