
const express = require('express');
const router = express.Router();
const { CognitoIdentityProviderClient, GlobalSignOutCommand } = require('@aws-sdk/client-cognito-identity-provider');
const { executeQuery, errorResponse, successResponse } = require('../utils/utils');
const { Login_Table } = require('../Database/Table_Names/TB_Name_Collection');

require('dotenv').config();
const { AWS_REGION } = process.env;

const client = new CognitoIdentityProviderClient({ 
    region: AWS_REGION, 
    credentials: {
        accessKeyId: 'AKIA4O3UASOWG7B2SG6A',
        secretAccessKey: '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'
    }
});

const logoutUser = async (AccessToken) => {
    const sql = `UPDATE ${Login_Table} SET is_login = ? WHERE access_token = ?`;
    const params = [0, AccessToken];

    return await executeQuery(sql,params);
}

router.post("/", async (req, res) => {
    try {
        const username = req.body.username;
        const AccessToken = req.body.access_token;

        const command = new GlobalSignOutCommand({
            AccessToken: AccessToken
        });
        const response = await client.send(command);
        
        res.clearCookie('accessToken', {
            httpOnly: false,
            secure: true,
            path: '/', 
            sameSite: 'None',
        });

        res.clearCookie('refreshToken', {
            httpOnly: false, 
            secure: true,
            path: '/', 
            sameSite: 'None',
        });

        const result = await logoutUser(username,AccessToken);
        successResponse(res, "Logout successfull");

    } catch (error) {
        if (error.name === 'NotAuthorizedException' && error.message === 'Access Token has expired') return errorResponse(res, 401, "Access Token Expired");

        if (error.name === 'NotAuthorizedException' && error.message === 'Invalid Access Token') return errorResponse(res, 401, "Invalid Access Token");
        
        if (error.name === 'NotAuthorizedException' && error.message === 'Access Token has been revoked') return errorResponse(res, 401, "Access Token has been revoked");
        
        console.log("Server error ",error);
        return errorResponse(res, 500, "Internal server error");
    }

});

module.exports = router;
