import React from 'react'
import Button from '@/components/ui/Button'
import Dialog from '@/components/ui/Dialog'

type BasicDialBoxProps = {
    dialogBoxOpen?: boolean,
    onDialogClose?: () => void,
    onDialogOk?: () => void
    dialogHeader?:string,
    dialogDescripation?:string,
}

const BasicDialBox: React.FC<BasicDialBoxProps> = ({ 
    dialogBoxOpen=false, 
    onDialogClose=()=>{}, 
    onDialogOk,
    dialogHeader="",
    dialogDescripation=""
 }) => {
    return (
        <>
            <Dialog
                isOpen={dialogBoxOpen}
                bodyOpenClassName="overflow-hidden"
                onClose={onDialogClose}
                onRequestClose={onDialogClose}
                shouldCloseOnOverlayClick={false}
            >
                <h4 className="mb-4">{dialogHeader}</h4>
                <p>{dialogDescripation}</p>
                <div className="text-right mt-6">
                    <Button
                        className="ltr:mr-2 rtl:ml-2"
                        variant="twoTone" color="red-600"
                        onClick={onDialogClose}
                    >
                        Cancel
                    </Button>
                    <Button variant="solid" onClick={onDialogOk}>
                        Yes, Sure!
                    </Button>
                </div>
            </Dialog>
        </>
    )
}

export default BasicDialBox
