import React, { useCallback } from 'react'
import toast from '@/components/ui/toast'
import Notification from '@/components/ui/Notification'

// Define the type for the notification type
type NotificationType = 'success' | 'warning' | 'danger' | 'info';

const useCustomToastify = () => {
    const notify = useCallback((type: NotificationType, message: string) => {
        toast.push(
            <Notification
                title={type.charAt(0).toUpperCase() + type.slice(1)}
                type={type}
            >
                {message || 'Default message'}
            </Notification>
        );
    }, []);
    
    return {
        success: (message:string) => notify('success', message),
        warning: (message:string) => notify('warning', message),
        danger: (message:string) => notify('danger', message),
        info: (message:string) => notify('info', message),
    };

}

export default useCustomToastify