import { UI_COMPONENTS_PREFIX_PATH } from '@/constants/route.constant'
import {
    NAV_ITEM_TYPE_TITLE,
    NAV_ITEM_TYPE_COLLAPSE,
    NAV_ITEM_TYPE_ITEM,
} from '@/constants/navigation.constant'
import { ADMIN, USER } from '@/constants/roles.constant'
import type { NavigationTree } from '@/@types/navigation'

const uiComponentNavigationConfig: NavigationTree[] = [
    {
        key: 'uiComponent.common',
        path: '',
        title: 'Common',
        translateKey: 'nav.uiComponentsCommon.common',
        icon: 'common',
        type: NAV_ITEM_TYPE_COLLAPSE,
        authority: [ADMIN, USER],
        subMenu: [
            {
                key: 'usersCrm.addApps',
                path: `${UI_COMPONENTS_PREFIX_PATH}/button`,
                title: 'Button',
                translateKey: 'nav.uiComponentsCommon.button',
                icon: '',
                type: NAV_ITEM_TYPE_ITEM,
                authority: [ADMIN, USER],
                subMenu: [],
            },
            {
                key: 'uiComponent.common.grid',
                path: `${UI_COMPONENTS_PREFIX_PATH}/grid`,
                title: 'Grid',
                translateKey: 'nav.uiComponentsCommon.grid',
                icon: '',
                type: NAV_ITEM_TYPE_ITEM,
                authority: [ADMIN, USER],
                subMenu: [],
            },
        ],
    },
]

export default uiComponentNavigationConfig
