import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { CognitoIdentityProviderServiceException as __BaseException } from "./CognitoIdentityProviderServiceException";
export declare const RecoveryOptionNameType: {
  readonly ADMIN_ONLY: "admin_only";
  readonly VERIFIED_EMAIL: "verified_email";
  readonly VERIFIED_PHONE_NUMBER: "verified_phone_number";
};
export type RecoveryOptionNameType =
  (typeof RecoveryOptionNameType)[keyof typeof RecoveryOptionNameType];
export interface RecoveryOptionType {
  Priority: number | undefined;
  Name: RecoveryOptionNameType | undefined;
}
export interface AccountRecoverySettingType {
  RecoveryMechanisms?: RecoveryOptionType[];
}
export declare const AccountTakeoverEventActionType: {
  readonly BLOCK: "BLOCK";
  readonly MFA_IF_CONFIGURED: "MFA_IF_CONFIGURED";
  readonly MFA_REQUIRED: "MFA_REQUIRED";
  readonly NO_ACTION: "NO_ACTION";
};
export type AccountTakeoverEventActionType =
  (typeof AccountTakeoverEventActionType)[keyof typeof AccountTakeoverEventActionType];
export interface AccountTakeoverActionType {
  Notify: boolean | undefined;
  EventAction: AccountTakeoverEventActionType | undefined;
}
export interface AccountTakeoverActionsType {
  LowAction?: AccountTakeoverActionType;
  MediumAction?: AccountTakeoverActionType;
  HighAction?: AccountTakeoverActionType;
}
export interface NotifyEmailType {
  Subject: string | undefined;
  HtmlBody?: string;
  TextBody?: string;
}
export interface NotifyConfigurationType {
  From?: string;
  ReplyTo?: string;
  SourceArn: string | undefined;
  BlockEmail?: NotifyEmailType;
  NoActionEmail?: NotifyEmailType;
  MfaEmail?: NotifyEmailType;
}
export interface AccountTakeoverRiskConfigurationType {
  NotifyConfiguration?: NotifyConfigurationType;
  Actions: AccountTakeoverActionsType | undefined;
}
export declare const AttributeDataType: {
  readonly BOOLEAN: "Boolean";
  readonly DATETIME: "DateTime";
  readonly NUMBER: "Number";
  readonly STRING: "String";
};
export type AttributeDataType =
  (typeof AttributeDataType)[keyof typeof AttributeDataType];
export interface NumberAttributeConstraintsType {
  MinValue?: string;
  MaxValue?: string;
}
export interface StringAttributeConstraintsType {
  MinLength?: string;
  MaxLength?: string;
}
export interface SchemaAttributeType {
  Name?: string;
  AttributeDataType?: AttributeDataType;
  DeveloperOnlyAttribute?: boolean;
  Mutable?: boolean;
  Required?: boolean;
  NumberAttributeConstraints?: NumberAttributeConstraintsType;
  StringAttributeConstraints?: StringAttributeConstraintsType;
}
export interface AddCustomAttributesRequest {
  UserPoolId: string | undefined;
  CustomAttributes: SchemaAttributeType[] | undefined;
}
export interface AddCustomAttributesResponse {}
export declare class InternalErrorException extends __BaseException {
  readonly name: "InternalErrorException";
  readonly $fault: "server";
  constructor(
    opts: __ExceptionOptionType<InternalErrorException, __BaseException>
  );
}
export declare class InvalidParameterException extends __BaseException {
  readonly name: "InvalidParameterException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidParameterException, __BaseException>
  );
}
export declare class NotAuthorizedException extends __BaseException {
  readonly name: "NotAuthorizedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<NotAuthorizedException, __BaseException>
  );
}
export declare class ResourceNotFoundException extends __BaseException {
  readonly name: "ResourceNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ResourceNotFoundException, __BaseException>
  );
}
export declare class TooManyRequestsException extends __BaseException {
  readonly name: "TooManyRequestsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TooManyRequestsException, __BaseException>
  );
}
export declare class UserImportInProgressException extends __BaseException {
  readonly name: "UserImportInProgressException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<UserImportInProgressException, __BaseException>
  );
}
export interface AdminAddUserToGroupRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  GroupName: string | undefined;
}
export declare class UserNotFoundException extends __BaseException {
  readonly name: "UserNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<UserNotFoundException, __BaseException>
  );
}
export interface AdminConfirmSignUpRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  ClientMetadata?: Record<string, string>;
}
export interface AdminConfirmSignUpResponse {}
export declare class InvalidLambdaResponseException extends __BaseException {
  readonly name: "InvalidLambdaResponseException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidLambdaResponseException, __BaseException>
  );
}
export declare class LimitExceededException extends __BaseException {
  readonly name: "LimitExceededException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<LimitExceededException, __BaseException>
  );
}
export declare class TooManyFailedAttemptsException extends __BaseException {
  readonly name: "TooManyFailedAttemptsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TooManyFailedAttemptsException, __BaseException>
  );
}
export declare class UnexpectedLambdaException extends __BaseException {
  readonly name: "UnexpectedLambdaException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<UnexpectedLambdaException, __BaseException>
  );
}
export declare class UserLambdaValidationException extends __BaseException {
  readonly name: "UserLambdaValidationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<UserLambdaValidationException, __BaseException>
  );
}
export declare const DeliveryMediumType: {
  readonly EMAIL: "EMAIL";
  readonly SMS: "SMS";
};
export type DeliveryMediumType =
  (typeof DeliveryMediumType)[keyof typeof DeliveryMediumType];
export declare const MessageActionType: {
  readonly RESEND: "RESEND";
  readonly SUPPRESS: "SUPPRESS";
};
export type MessageActionType =
  (typeof MessageActionType)[keyof typeof MessageActionType];
export interface AttributeType {
  Name: string | undefined;
  Value?: string;
}
export interface AdminCreateUserRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  UserAttributes?: AttributeType[];
  ValidationData?: AttributeType[];
  TemporaryPassword?: string;
  ForceAliasCreation?: boolean;
  MessageAction?: MessageActionType;
  DesiredDeliveryMediums?: DeliveryMediumType[];
  ClientMetadata?: Record<string, string>;
}
export interface MFAOptionType {
  DeliveryMedium?: DeliveryMediumType;
  AttributeName?: string;
}
export declare const UserStatusType: {
  readonly ARCHIVED: "ARCHIVED";
  readonly COMPROMISED: "COMPROMISED";
  readonly CONFIRMED: "CONFIRMED";
  readonly EXTERNAL_PROVIDER: "EXTERNAL_PROVIDER";
  readonly FORCE_CHANGE_PASSWORD: "FORCE_CHANGE_PASSWORD";
  readonly RESET_REQUIRED: "RESET_REQUIRED";
  readonly UNCONFIRMED: "UNCONFIRMED";
  readonly UNKNOWN: "UNKNOWN";
};
export type UserStatusType =
  (typeof UserStatusType)[keyof typeof UserStatusType];
export interface UserType {
  Username?: string;
  Attributes?: AttributeType[];
  UserCreateDate?: Date;
  UserLastModifiedDate?: Date;
  Enabled?: boolean;
  UserStatus?: UserStatusType;
  MFAOptions?: MFAOptionType[];
}
export interface AdminCreateUserResponse {
  User?: UserType;
}
export declare class CodeDeliveryFailureException extends __BaseException {
  readonly name: "CodeDeliveryFailureException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<CodeDeliveryFailureException, __BaseException>
  );
}
export declare class InvalidPasswordException extends __BaseException {
  readonly name: "InvalidPasswordException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidPasswordException, __BaseException>
  );
}
export declare class InvalidSmsRoleAccessPolicyException extends __BaseException {
  readonly name: "InvalidSmsRoleAccessPolicyException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidSmsRoleAccessPolicyException,
      __BaseException
    >
  );
}
export declare class InvalidSmsRoleTrustRelationshipException extends __BaseException {
  readonly name: "InvalidSmsRoleTrustRelationshipException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidSmsRoleTrustRelationshipException,
      __BaseException
    >
  );
}
export declare class PreconditionNotMetException extends __BaseException {
  readonly name: "PreconditionNotMetException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<PreconditionNotMetException, __BaseException>
  );
}
export declare class UnsupportedUserStateException extends __BaseException {
  readonly name: "UnsupportedUserStateException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<UnsupportedUserStateException, __BaseException>
  );
}
export declare class UsernameExistsException extends __BaseException {
  readonly name: "UsernameExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<UsernameExistsException, __BaseException>
  );
}
export interface MessageTemplateType {
  SMSMessage?: string;
  EmailMessage?: string;
  EmailSubject?: string;
}
export interface AdminCreateUserConfigType {
  AllowAdminCreateUserOnly?: boolean;
  UnusedAccountValidityDays?: number;
  InviteMessageTemplate?: MessageTemplateType;
}
export interface AdminDeleteUserRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
}
export interface AdminDeleteUserAttributesRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  UserAttributeNames: string[] | undefined;
}
export interface AdminDeleteUserAttributesResponse {}
export interface ProviderUserIdentifierType {
  ProviderName?: string;
  ProviderAttributeName?: string;
  ProviderAttributeValue?: string;
}
export interface AdminDisableProviderForUserRequest {
  UserPoolId: string | undefined;
  User: ProviderUserIdentifierType | undefined;
}
export interface AdminDisableProviderForUserResponse {}
export declare class AliasExistsException extends __BaseException {
  readonly name: "AliasExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<AliasExistsException, __BaseException>
  );
}
export interface AdminDisableUserRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
}
export interface AdminDisableUserResponse {}
export interface AdminEnableUserRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
}
export interface AdminEnableUserResponse {}
export interface AdminForgetDeviceRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  DeviceKey: string | undefined;
}
export declare class InvalidUserPoolConfigurationException extends __BaseException {
  readonly name: "InvalidUserPoolConfigurationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidUserPoolConfigurationException,
      __BaseException
    >
  );
}
export interface AdminGetDeviceRequest {
  DeviceKey: string | undefined;
  UserPoolId: string | undefined;
  Username: string | undefined;
}
export interface DeviceType {
  DeviceKey?: string;
  DeviceAttributes?: AttributeType[];
  DeviceCreateDate?: Date;
  DeviceLastModifiedDate?: Date;
  DeviceLastAuthenticatedDate?: Date;
}
export interface AdminGetDeviceResponse {
  Device: DeviceType | undefined;
}
export interface AdminGetUserRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
}
export interface AdminGetUserResponse {
  Username: string | undefined;
  UserAttributes?: AttributeType[];
  UserCreateDate?: Date;
  UserLastModifiedDate?: Date;
  Enabled?: boolean;
  UserStatus?: UserStatusType;
  MFAOptions?: MFAOptionType[];
  PreferredMfaSetting?: string;
  UserMFASettingList?: string[];
}
export interface AnalyticsMetadataType {
  AnalyticsEndpointId?: string;
}
export declare const AuthFlowType: {
  readonly ADMIN_NO_SRP_AUTH: "ADMIN_NO_SRP_AUTH";
  readonly ADMIN_USER_PASSWORD_AUTH: "ADMIN_USER_PASSWORD_AUTH";
  readonly CUSTOM_AUTH: "CUSTOM_AUTH";
  readonly REFRESH_TOKEN: "REFRESH_TOKEN";
  readonly REFRESH_TOKEN_AUTH: "REFRESH_TOKEN_AUTH";
  readonly USER_PASSWORD_AUTH: "USER_PASSWORD_AUTH";
  readonly USER_SRP_AUTH: "USER_SRP_AUTH";
};
export type AuthFlowType = (typeof AuthFlowType)[keyof typeof AuthFlowType];
export interface HttpHeader {
  headerName?: string;
  headerValue?: string;
}
export interface ContextDataType {
  IpAddress: string | undefined;
  ServerName: string | undefined;
  ServerPath: string | undefined;
  HttpHeaders: HttpHeader[] | undefined;
  EncodedData?: string;
}
export interface AdminInitiateAuthRequest {
  UserPoolId: string | undefined;
  ClientId: string | undefined;
  AuthFlow: AuthFlowType | undefined;
  AuthParameters?: Record<string, string>;
  ClientMetadata?: Record<string, string>;
  AnalyticsMetadata?: AnalyticsMetadataType;
  ContextData?: ContextDataType;
}
export interface NewDeviceMetadataType {
  DeviceKey?: string;
  DeviceGroupKey?: string;
}
export interface AuthenticationResultType {
  AccessToken?: string;
  ExpiresIn?: number;
  TokenType?: string;
  RefreshToken?: string;
  IdToken?: string;
  NewDeviceMetadata?: NewDeviceMetadataType;
}
export declare const ChallengeNameType: {
  readonly ADMIN_NO_SRP_AUTH: "ADMIN_NO_SRP_AUTH";
  readonly CUSTOM_CHALLENGE: "CUSTOM_CHALLENGE";
  readonly DEVICE_PASSWORD_VERIFIER: "DEVICE_PASSWORD_VERIFIER";
  readonly DEVICE_SRP_AUTH: "DEVICE_SRP_AUTH";
  readonly MFA_SETUP: "MFA_SETUP";
  readonly NEW_PASSWORD_REQUIRED: "NEW_PASSWORD_REQUIRED";
  readonly PASSWORD_VERIFIER: "PASSWORD_VERIFIER";
  readonly SELECT_MFA_TYPE: "SELECT_MFA_TYPE";
  readonly SMS_MFA: "SMS_MFA";
  readonly SOFTWARE_TOKEN_MFA: "SOFTWARE_TOKEN_MFA";
};
export type ChallengeNameType =
  (typeof ChallengeNameType)[keyof typeof ChallengeNameType];
export interface AdminInitiateAuthResponse {
  ChallengeName?: ChallengeNameType;
  Session?: string;
  ChallengeParameters?: Record<string, string>;
  AuthenticationResult?: AuthenticationResultType;
}
export declare class MFAMethodNotFoundException extends __BaseException {
  readonly name: "MFAMethodNotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<MFAMethodNotFoundException, __BaseException>
  );
}
export declare class PasswordResetRequiredException extends __BaseException {
  readonly name: "PasswordResetRequiredException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<PasswordResetRequiredException, __BaseException>
  );
}
export declare class UserNotConfirmedException extends __BaseException {
  readonly name: "UserNotConfirmedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<UserNotConfirmedException, __BaseException>
  );
}
export interface AdminLinkProviderForUserRequest {
  UserPoolId: string | undefined;
  DestinationUser: ProviderUserIdentifierType | undefined;
  SourceUser: ProviderUserIdentifierType | undefined;
}
export interface AdminLinkProviderForUserResponse {}
export interface AdminListDevicesRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  Limit?: number;
  PaginationToken?: string;
}
export interface AdminListDevicesResponse {
  Devices?: DeviceType[];
  PaginationToken?: string;
}
export interface AdminListGroupsForUserRequest {
  Username: string | undefined;
  UserPoolId: string | undefined;
  Limit?: number;
  NextToken?: string;
}
export interface GroupType {
  GroupName?: string;
  UserPoolId?: string;
  Description?: string;
  RoleArn?: string;
  Precedence?: number;
  LastModifiedDate?: Date;
  CreationDate?: Date;
}
export interface AdminListGroupsForUserResponse {
  Groups?: GroupType[];
  NextToken?: string;
}
export interface AdminListUserAuthEventsRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export declare const ChallengeName: {
  readonly Mfa: "Mfa";
  readonly Password: "Password";
};
export type ChallengeName = (typeof ChallengeName)[keyof typeof ChallengeName];
export declare const ChallengeResponse: {
  readonly Failure: "Failure";
  readonly Success: "Success";
};
export type ChallengeResponse =
  (typeof ChallengeResponse)[keyof typeof ChallengeResponse];
export interface ChallengeResponseType {
  ChallengeName?: ChallengeName;
  ChallengeResponse?: ChallengeResponse;
}
export interface EventContextDataType {
  IpAddress?: string;
  DeviceName?: string;
  Timezone?: string;
  City?: string;
  Country?: string;
}
export declare const FeedbackValueType: {
  readonly INVALID: "Invalid";
  readonly VALID: "Valid";
};
export type FeedbackValueType =
  (typeof FeedbackValueType)[keyof typeof FeedbackValueType];
export interface EventFeedbackType {
  FeedbackValue: FeedbackValueType | undefined;
  Provider: string | undefined;
  FeedbackDate?: Date;
}
export declare const EventResponseType: {
  readonly Fail: "Fail";
  readonly InProgress: "InProgress";
  readonly Pass: "Pass";
};
export type EventResponseType =
  (typeof EventResponseType)[keyof typeof EventResponseType];
export declare const RiskDecisionType: {
  readonly AccountTakeover: "AccountTakeover";
  readonly Block: "Block";
  readonly NoRisk: "NoRisk";
};
export type RiskDecisionType =
  (typeof RiskDecisionType)[keyof typeof RiskDecisionType];
export declare const RiskLevelType: {
  readonly High: "High";
  readonly Low: "Low";
  readonly Medium: "Medium";
};
export type RiskLevelType = (typeof RiskLevelType)[keyof typeof RiskLevelType];
export interface EventRiskType {
  RiskDecision?: RiskDecisionType;
  RiskLevel?: RiskLevelType;
  CompromisedCredentialsDetected?: boolean;
}
export declare const EventType: {
  readonly ForgotPassword: "ForgotPassword";
  readonly PasswordChange: "PasswordChange";
  readonly ResendCode: "ResendCode";
  readonly SignIn: "SignIn";
  readonly SignUp: "SignUp";
};
export type EventType = (typeof EventType)[keyof typeof EventType];
export interface AuthEventType {
  EventId?: string;
  EventType?: EventType;
  CreationDate?: Date;
  EventResponse?: EventResponseType;
  EventRisk?: EventRiskType;
  ChallengeResponses?: ChallengeResponseType[];
  EventContextData?: EventContextDataType;
  EventFeedback?: EventFeedbackType;
}
export interface AdminListUserAuthEventsResponse {
  AuthEvents?: AuthEventType[];
  NextToken?: string;
}
export declare class UserPoolAddOnNotEnabledException extends __BaseException {
  readonly name: "UserPoolAddOnNotEnabledException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      UserPoolAddOnNotEnabledException,
      __BaseException
    >
  );
}
export interface AdminRemoveUserFromGroupRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  GroupName: string | undefined;
}
export interface AdminResetUserPasswordRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  ClientMetadata?: Record<string, string>;
}
export interface AdminResetUserPasswordResponse {}
export declare class InvalidEmailRoleAccessPolicyException extends __BaseException {
  readonly name: "InvalidEmailRoleAccessPolicyException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidEmailRoleAccessPolicyException,
      __BaseException
    >
  );
}
export interface AdminRespondToAuthChallengeRequest {
  UserPoolId: string | undefined;
  ClientId: string | undefined;
  ChallengeName: ChallengeNameType | undefined;
  ChallengeResponses?: Record<string, string>;
  Session?: string;
  AnalyticsMetadata?: AnalyticsMetadataType;
  ContextData?: ContextDataType;
  ClientMetadata?: Record<string, string>;
}
export interface AdminRespondToAuthChallengeResponse {
  ChallengeName?: ChallengeNameType;
  Session?: string;
  ChallengeParameters?: Record<string, string>;
  AuthenticationResult?: AuthenticationResultType;
}
export declare class CodeMismatchException extends __BaseException {
  readonly name: "CodeMismatchException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<CodeMismatchException, __BaseException>
  );
}
export declare class ExpiredCodeException extends __BaseException {
  readonly name: "ExpiredCodeException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ExpiredCodeException, __BaseException>
  );
}
export declare class PasswordHistoryPolicyViolationException extends __BaseException {
  readonly name: "PasswordHistoryPolicyViolationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      PasswordHistoryPolicyViolationException,
      __BaseException
    >
  );
}
export declare class SoftwareTokenMFANotFoundException extends __BaseException {
  readonly name: "SoftwareTokenMFANotFoundException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      SoftwareTokenMFANotFoundException,
      __BaseException
    >
  );
}
export interface SMSMfaSettingsType {
  Enabled?: boolean;
  PreferredMfa?: boolean;
}
export interface SoftwareTokenMfaSettingsType {
  Enabled?: boolean;
  PreferredMfa?: boolean;
}
export interface AdminSetUserMFAPreferenceRequest {
  SMSMfaSettings?: SMSMfaSettingsType;
  SoftwareTokenMfaSettings?: SoftwareTokenMfaSettingsType;
  Username: string | undefined;
  UserPoolId: string | undefined;
}
export interface AdminSetUserMFAPreferenceResponse {}
export interface AdminSetUserPasswordRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  Password: string | undefined;
  Permanent?: boolean;
}
export interface AdminSetUserPasswordResponse {}
export interface AdminSetUserSettingsRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  MFAOptions: MFAOptionType[] | undefined;
}
export interface AdminSetUserSettingsResponse {}
export interface AdminUpdateAuthEventFeedbackRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  EventId: string | undefined;
  FeedbackValue: FeedbackValueType | undefined;
}
export interface AdminUpdateAuthEventFeedbackResponse {}
export declare const DeviceRememberedStatusType: {
  readonly NOT_REMEMBERED: "not_remembered";
  readonly REMEMBERED: "remembered";
};
export type DeviceRememberedStatusType =
  (typeof DeviceRememberedStatusType)[keyof typeof DeviceRememberedStatusType];
export interface AdminUpdateDeviceStatusRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  DeviceKey: string | undefined;
  DeviceRememberedStatus?: DeviceRememberedStatusType;
}
export interface AdminUpdateDeviceStatusResponse {}
export interface AdminUpdateUserAttributesRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
  UserAttributes: AttributeType[] | undefined;
  ClientMetadata?: Record<string, string>;
}
export interface AdminUpdateUserAttributesResponse {}
export interface AdminUserGlobalSignOutRequest {
  UserPoolId: string | undefined;
  Username: string | undefined;
}
export interface AdminUserGlobalSignOutResponse {}
export declare const AdvancedSecurityEnabledModeType: {
  readonly AUDIT: "AUDIT";
  readonly ENFORCED: "ENFORCED";
};
export type AdvancedSecurityEnabledModeType =
  (typeof AdvancedSecurityEnabledModeType)[keyof typeof AdvancedSecurityEnabledModeType];
export interface AdvancedSecurityAdditionalFlowsType {
  CustomAuthMode?: AdvancedSecurityEnabledModeType;
}
export declare const AdvancedSecurityModeType: {
  readonly AUDIT: "AUDIT";
  readonly ENFORCED: "ENFORCED";
  readonly OFF: "OFF";
};
export type AdvancedSecurityModeType =
  (typeof AdvancedSecurityModeType)[keyof typeof AdvancedSecurityModeType];
export declare const AliasAttributeType: {
  readonly EMAIL: "email";
  readonly PHONE_NUMBER: "phone_number";
  readonly PREFERRED_USERNAME: "preferred_username";
};
export type AliasAttributeType =
  (typeof AliasAttributeType)[keyof typeof AliasAttributeType];
export interface AnalyticsConfigurationType {
  ApplicationId?: string;
  ApplicationArn?: string;
  RoleArn?: string;
  ExternalId?: string;
  UserDataShared?: boolean;
}
export interface AssociateSoftwareTokenRequest {
  AccessToken?: string;
  Session?: string;
}
export interface AssociateSoftwareTokenResponse {
  SecretCode?: string;
  Session?: string;
}
export declare class ConcurrentModificationException extends __BaseException {
  readonly name: "ConcurrentModificationException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ConcurrentModificationException,
      __BaseException
    >
  );
}
export declare class ForbiddenException extends __BaseException {
  readonly name: "ForbiddenException";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<ForbiddenException, __BaseException>);
}
export declare const VerifiedAttributeType: {
  readonly EMAIL: "email";
  readonly PHONE_NUMBER: "phone_number";
};
export type VerifiedAttributeType =
  (typeof VerifiedAttributeType)[keyof typeof VerifiedAttributeType];
export interface ChangePasswordRequest {
  PreviousPassword: string | undefined;
  ProposedPassword: string | undefined;
  AccessToken: string | undefined;
}
export interface ChangePasswordResponse {}
export interface DeviceSecretVerifierConfigType {
  PasswordVerifier?: string;
  Salt?: string;
}
export interface ConfirmDeviceRequest {
  AccessToken: string | undefined;
  DeviceKey: string | undefined;
  DeviceSecretVerifierConfig?: DeviceSecretVerifierConfigType;
  DeviceName?: string;
}
export interface ConfirmDeviceResponse {
  UserConfirmationNecessary?: boolean;
}
export interface UserContextDataType {
  IpAddress?: string;
  EncodedData?: string;
}
export interface ConfirmForgotPasswordRequest {
  ClientId: string | undefined;
  SecretHash?: string;
  Username: string | undefined;
  ConfirmationCode: string | undefined;
  Password: string | undefined;
  AnalyticsMetadata?: AnalyticsMetadataType;
  UserContextData?: UserContextDataType;
  ClientMetadata?: Record<string, string>;
}
export interface ConfirmForgotPasswordResponse {}
export interface ConfirmSignUpRequest {
  ClientId: string | undefined;
  SecretHash?: string;
  Username: string | undefined;
  ConfirmationCode: string | undefined;
  ForceAliasCreation?: boolean;
  AnalyticsMetadata?: AnalyticsMetadataType;
  UserContextData?: UserContextDataType;
  ClientMetadata?: Record<string, string>;
}
export interface ConfirmSignUpResponse {}
export interface CreateGroupRequest {
  GroupName: string | undefined;
  UserPoolId: string | undefined;
  Description?: string;
  RoleArn?: string;
  Precedence?: number;
}
export interface CreateGroupResponse {
  Group?: GroupType;
}
export declare class GroupExistsException extends __BaseException {
  readonly name: "GroupExistsException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<GroupExistsException, __BaseException>
  );
}
export declare const IdentityProviderTypeType: {
  readonly Facebook: "Facebook";
  readonly Google: "Google";
  readonly LoginWithAmazon: "LoginWithAmazon";
  readonly OIDC: "OIDC";
  readonly SAML: "SAML";
  readonly SignInWithApple: "SignInWithApple";
};
export type IdentityProviderTypeType =
  (typeof IdentityProviderTypeType)[keyof typeof IdentityProviderTypeType];
export interface CreateIdentityProviderRequest {
  UserPoolId: string | undefined;
  ProviderName: string | undefined;
  ProviderType: IdentityProviderTypeType | undefined;
  ProviderDetails: Record<string, string> | undefined;
  AttributeMapping?: Record<string, string>;
  IdpIdentifiers?: string[];
}
export interface IdentityProviderType {
  UserPoolId?: string;
  ProviderName?: string;
  ProviderType?: IdentityProviderTypeType;
  ProviderDetails?: Record<string, string>;
  AttributeMapping?: Record<string, string>;
  IdpIdentifiers?: string[];
  LastModifiedDate?: Date;
  CreationDate?: Date;
}
export interface CreateIdentityProviderResponse {
  IdentityProvider: IdentityProviderType | undefined;
}
export declare class DuplicateProviderException extends __BaseException {
  readonly name: "DuplicateProviderException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DuplicateProviderException, __BaseException>
  );
}
export interface ResourceServerScopeType {
  ScopeName: string | undefined;
  ScopeDescription: string | undefined;
}
export interface CreateResourceServerRequest {
  UserPoolId: string | undefined;
  Identifier: string | undefined;
  Name: string | undefined;
  Scopes?: ResourceServerScopeType[];
}
export interface ResourceServerType {
  UserPoolId?: string;
  Identifier?: string;
  Name?: string;
  Scopes?: ResourceServerScopeType[];
}
export interface CreateResourceServerResponse {
  ResourceServer: ResourceServerType | undefined;
}
export interface CreateUserImportJobRequest {
  JobName: string | undefined;
  UserPoolId: string | undefined;
  CloudWatchLogsRoleArn: string | undefined;
}
export declare const UserImportJobStatusType: {
  readonly Created: "Created";
  readonly Expired: "Expired";
  readonly Failed: "Failed";
  readonly InProgress: "InProgress";
  readonly Pending: "Pending";
  readonly Stopped: "Stopped";
  readonly Stopping: "Stopping";
  readonly Succeeded: "Succeeded";
};
export type UserImportJobStatusType =
  (typeof UserImportJobStatusType)[keyof typeof UserImportJobStatusType];
export interface UserImportJobType {
  JobName?: string;
  JobId?: string;
  UserPoolId?: string;
  PreSignedUrl?: string;
  CreationDate?: Date;
  StartDate?: Date;
  CompletionDate?: Date;
  Status?: UserImportJobStatusType;
  CloudWatchLogsRoleArn?: string;
  ImportedUsers?: number;
  SkippedUsers?: number;
  FailedUsers?: number;
  CompletionMessage?: string;
}
export interface CreateUserImportJobResponse {
  UserImportJob?: UserImportJobType;
}
export declare const DeletionProtectionType: {
  readonly ACTIVE: "ACTIVE";
  readonly INACTIVE: "INACTIVE";
};
export type DeletionProtectionType =
  (typeof DeletionProtectionType)[keyof typeof DeletionProtectionType];
export interface DeviceConfigurationType {
  ChallengeRequiredOnNewDevice?: boolean;
  DeviceOnlyRememberedOnUserPrompt?: boolean;
}
export declare const EmailSendingAccountType: {
  readonly COGNITO_DEFAULT: "COGNITO_DEFAULT";
  readonly DEVELOPER: "DEVELOPER";
};
export type EmailSendingAccountType =
  (typeof EmailSendingAccountType)[keyof typeof EmailSendingAccountType];
export interface EmailConfigurationType {
  SourceArn?: string;
  ReplyToEmailAddress?: string;
  EmailSendingAccount?: EmailSendingAccountType;
  From?: string;
  ConfigurationSet?: string;
}
export declare const CustomEmailSenderLambdaVersionType: {
  readonly V1_0: "V1_0";
};
export type CustomEmailSenderLambdaVersionType =
  (typeof CustomEmailSenderLambdaVersionType)[keyof typeof CustomEmailSenderLambdaVersionType];
export interface CustomEmailLambdaVersionConfigType {
  LambdaVersion: CustomEmailSenderLambdaVersionType | undefined;
  LambdaArn: string | undefined;
}
export declare const CustomSMSSenderLambdaVersionType: {
  readonly V1_0: "V1_0";
};
export type CustomSMSSenderLambdaVersionType =
  (typeof CustomSMSSenderLambdaVersionType)[keyof typeof CustomSMSSenderLambdaVersionType];
export interface CustomSMSLambdaVersionConfigType {
  LambdaVersion: CustomSMSSenderLambdaVersionType | undefined;
  LambdaArn: string | undefined;
}
export declare const PreTokenGenerationLambdaVersionType: {
  readonly V1_0: "V1_0";
  readonly V2_0: "V2_0";
};
export type PreTokenGenerationLambdaVersionType =
  (typeof PreTokenGenerationLambdaVersionType)[keyof typeof PreTokenGenerationLambdaVersionType];
export interface PreTokenGenerationVersionConfigType {
  LambdaVersion: PreTokenGenerationLambdaVersionType | undefined;
  LambdaArn: string | undefined;
}
export interface LambdaConfigType {
  PreSignUp?: string;
  CustomMessage?: string;
  PostConfirmation?: string;
  PreAuthentication?: string;
  PostAuthentication?: string;
  DefineAuthChallenge?: string;
  CreateAuthChallenge?: string;
  VerifyAuthChallengeResponse?: string;
  PreTokenGeneration?: string;
  UserMigration?: string;
  PreTokenGenerationConfig?: PreTokenGenerationVersionConfigType;
  CustomSMSSender?: CustomSMSLambdaVersionConfigType;
  CustomEmailSender?: CustomEmailLambdaVersionConfigType;
  KMSKeyID?: string;
}
export declare const UserPoolMfaType: {
  readonly OFF: "OFF";
  readonly ON: "ON";
  readonly OPTIONAL: "OPTIONAL";
};
export type UserPoolMfaType =
  (typeof UserPoolMfaType)[keyof typeof UserPoolMfaType];
export interface PasswordPolicyType {
  MinimumLength?: number;
  RequireUppercase?: boolean;
  RequireLowercase?: boolean;
  RequireNumbers?: boolean;
  RequireSymbols?: boolean;
  PasswordHistorySize?: number;
  TemporaryPasswordValidityDays?: number;
}
export interface UserPoolPolicyType {
  PasswordPolicy?: PasswordPolicyType;
}
export interface SmsConfigurationType {
  SnsCallerArn: string | undefined;
  ExternalId?: string;
  SnsRegion?: string;
}
export interface UserAttributeUpdateSettingsType {
  AttributesRequireVerificationBeforeUpdate?: VerifiedAttributeType[];
}
export declare const UsernameAttributeType: {
  readonly EMAIL: "email";
  readonly PHONE_NUMBER: "phone_number";
};
export type UsernameAttributeType =
  (typeof UsernameAttributeType)[keyof typeof UsernameAttributeType];
export interface UsernameConfigurationType {
  CaseSensitive: boolean | undefined;
}
export interface UserPoolAddOnsType {
  AdvancedSecurityMode: AdvancedSecurityModeType | undefined;
  AdvancedSecurityAdditionalFlows?: AdvancedSecurityAdditionalFlowsType;
}
export declare const DefaultEmailOptionType: {
  readonly CONFIRM_WITH_CODE: "CONFIRM_WITH_CODE";
  readonly CONFIRM_WITH_LINK: "CONFIRM_WITH_LINK";
};
export type DefaultEmailOptionType =
  (typeof DefaultEmailOptionType)[keyof typeof DefaultEmailOptionType];
export interface VerificationMessageTemplateType {
  SmsMessage?: string;
  EmailMessage?: string;
  EmailSubject?: string;
  EmailMessageByLink?: string;
  EmailSubjectByLink?: string;
  DefaultEmailOption?: DefaultEmailOptionType;
}
export interface CreateUserPoolRequest {
  PoolName: string | undefined;
  Policies?: UserPoolPolicyType;
  DeletionProtection?: DeletionProtectionType;
  LambdaConfig?: LambdaConfigType;
  AutoVerifiedAttributes?: VerifiedAttributeType[];
  AliasAttributes?: AliasAttributeType[];
  UsernameAttributes?: UsernameAttributeType[];
  SmsVerificationMessage?: string;
  EmailVerificationMessage?: string;
  EmailVerificationSubject?: string;
  VerificationMessageTemplate?: VerificationMessageTemplateType;
  SmsAuthenticationMessage?: string;
  MfaConfiguration?: UserPoolMfaType;
  UserAttributeUpdateSettings?: UserAttributeUpdateSettingsType;
  DeviceConfiguration?: DeviceConfigurationType;
  EmailConfiguration?: EmailConfigurationType;
  SmsConfiguration?: SmsConfigurationType;
  UserPoolTags?: Record<string, string>;
  AdminCreateUserConfig?: AdminCreateUserConfigType;
  Schema?: SchemaAttributeType[];
  UserPoolAddOns?: UserPoolAddOnsType;
  UsernameConfiguration?: UsernameConfigurationType;
  AccountRecoverySetting?: AccountRecoverySettingType;
}
export declare const StatusType: {
  readonly Disabled: "Disabled";
  readonly Enabled: "Enabled";
};
export type StatusType = (typeof StatusType)[keyof typeof StatusType];
export interface UserPoolType {
  Id?: string;
  Name?: string;
  Policies?: UserPoolPolicyType;
  DeletionProtection?: DeletionProtectionType;
  LambdaConfig?: LambdaConfigType;
  Status?: StatusType;
  LastModifiedDate?: Date;
  CreationDate?: Date;
  SchemaAttributes?: SchemaAttributeType[];
  AutoVerifiedAttributes?: VerifiedAttributeType[];
  AliasAttributes?: AliasAttributeType[];
  UsernameAttributes?: UsernameAttributeType[];
  SmsVerificationMessage?: string;
  EmailVerificationMessage?: string;
  EmailVerificationSubject?: string;
  VerificationMessageTemplate?: VerificationMessageTemplateType;
  SmsAuthenticationMessage?: string;
  UserAttributeUpdateSettings?: UserAttributeUpdateSettingsType;
  MfaConfiguration?: UserPoolMfaType;
  DeviceConfiguration?: DeviceConfigurationType;
  EstimatedNumberOfUsers?: number;
  EmailConfiguration?: EmailConfigurationType;
  SmsConfiguration?: SmsConfigurationType;
  UserPoolTags?: Record<string, string>;
  SmsConfigurationFailure?: string;
  EmailConfigurationFailure?: string;
  Domain?: string;
  CustomDomain?: string;
  AdminCreateUserConfig?: AdminCreateUserConfigType;
  UserPoolAddOns?: UserPoolAddOnsType;
  UsernameConfiguration?: UsernameConfigurationType;
  Arn?: string;
  AccountRecoverySetting?: AccountRecoverySettingType;
}
export interface CreateUserPoolResponse {
  UserPool?: UserPoolType;
}
export declare class UserPoolTaggingException extends __BaseException {
  readonly name: "UserPoolTaggingException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<UserPoolTaggingException, __BaseException>
  );
}
export declare const OAuthFlowType: {
  readonly client_credentials: "client_credentials";
  readonly code: "code";
  readonly implicit: "implicit";
};
export type OAuthFlowType = (typeof OAuthFlowType)[keyof typeof OAuthFlowType];
export declare const ExplicitAuthFlowsType: {
  readonly ADMIN_NO_SRP_AUTH: "ADMIN_NO_SRP_AUTH";
  readonly ALLOW_ADMIN_USER_PASSWORD_AUTH: "ALLOW_ADMIN_USER_PASSWORD_AUTH";
  readonly ALLOW_CUSTOM_AUTH: "ALLOW_CUSTOM_AUTH";
  readonly ALLOW_REFRESH_TOKEN_AUTH: "ALLOW_REFRESH_TOKEN_AUTH";
  readonly ALLOW_USER_PASSWORD_AUTH: "ALLOW_USER_PASSWORD_AUTH";
  readonly ALLOW_USER_SRP_AUTH: "ALLOW_USER_SRP_AUTH";
  readonly CUSTOM_AUTH_FLOW_ONLY: "CUSTOM_AUTH_FLOW_ONLY";
  readonly USER_PASSWORD_AUTH: "USER_PASSWORD_AUTH";
};
export type ExplicitAuthFlowsType =
  (typeof ExplicitAuthFlowsType)[keyof typeof ExplicitAuthFlowsType];
export declare const PreventUserExistenceErrorTypes: {
  readonly ENABLED: "ENABLED";
  readonly LEGACY: "LEGACY";
};
export type PreventUserExistenceErrorTypes =
  (typeof PreventUserExistenceErrorTypes)[keyof typeof PreventUserExistenceErrorTypes];
export declare const TimeUnitsType: {
  readonly DAYS: "days";
  readonly HOURS: "hours";
  readonly MINUTES: "minutes";
  readonly SECONDS: "seconds";
};
export type TimeUnitsType = (typeof TimeUnitsType)[keyof typeof TimeUnitsType];
export interface TokenValidityUnitsType {
  AccessToken?: TimeUnitsType;
  IdToken?: TimeUnitsType;
  RefreshToken?: TimeUnitsType;
}
export interface CreateUserPoolClientRequest {
  UserPoolId: string | undefined;
  ClientName: string | undefined;
  GenerateSecret?: boolean;
  RefreshTokenValidity?: number;
  AccessTokenValidity?: number;
  IdTokenValidity?: number;
  TokenValidityUnits?: TokenValidityUnitsType;
  ReadAttributes?: string[];
  WriteAttributes?: string[];
  ExplicitAuthFlows?: ExplicitAuthFlowsType[];
  SupportedIdentityProviders?: string[];
  CallbackURLs?: string[];
  LogoutURLs?: string[];
  DefaultRedirectURI?: string;
  AllowedOAuthFlows?: OAuthFlowType[];
  AllowedOAuthScopes?: string[];
  AllowedOAuthFlowsUserPoolClient?: boolean;
  AnalyticsConfiguration?: AnalyticsConfigurationType;
  PreventUserExistenceErrors?: PreventUserExistenceErrorTypes;
  EnableTokenRevocation?: boolean;
  EnablePropagateAdditionalUserContextData?: boolean;
  AuthSessionValidity?: number;
}
export interface UserPoolClientType {
  UserPoolId?: string;
  ClientName?: string;
  ClientId?: string;
  ClientSecret?: string;
  LastModifiedDate?: Date;
  CreationDate?: Date;
  RefreshTokenValidity?: number;
  AccessTokenValidity?: number;
  IdTokenValidity?: number;
  TokenValidityUnits?: TokenValidityUnitsType;
  ReadAttributes?: string[];
  WriteAttributes?: string[];
  ExplicitAuthFlows?: ExplicitAuthFlowsType[];
  SupportedIdentityProviders?: string[];
  CallbackURLs?: string[];
  LogoutURLs?: string[];
  DefaultRedirectURI?: string;
  AllowedOAuthFlows?: OAuthFlowType[];
  AllowedOAuthScopes?: string[];
  AllowedOAuthFlowsUserPoolClient?: boolean;
  AnalyticsConfiguration?: AnalyticsConfigurationType;
  PreventUserExistenceErrors?: PreventUserExistenceErrorTypes;
  EnableTokenRevocation?: boolean;
  EnablePropagateAdditionalUserContextData?: boolean;
  AuthSessionValidity?: number;
}
export interface CreateUserPoolClientResponse {
  UserPoolClient?: UserPoolClientType;
}
export declare class InvalidOAuthFlowException extends __BaseException {
  readonly name: "InvalidOAuthFlowException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidOAuthFlowException, __BaseException>
  );
}
export declare class ScopeDoesNotExistException extends __BaseException {
  readonly name: "ScopeDoesNotExistException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ScopeDoesNotExistException, __BaseException>
  );
}
export interface CustomDomainConfigType {
  CertificateArn: string | undefined;
}
export interface CreateUserPoolDomainRequest {
  Domain: string | undefined;
  UserPoolId: string | undefined;
  CustomDomainConfig?: CustomDomainConfigType;
}
export interface CreateUserPoolDomainResponse {
  CloudFrontDomain?: string;
}
export interface DeleteGroupRequest {
  GroupName: string | undefined;
  UserPoolId: string | undefined;
}
export interface DeleteIdentityProviderRequest {
  UserPoolId: string | undefined;
  ProviderName: string | undefined;
}
export declare class UnsupportedIdentityProviderException extends __BaseException {
  readonly name: "UnsupportedIdentityProviderException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      UnsupportedIdentityProviderException,
      __BaseException
    >
  );
}
export interface DeleteResourceServerRequest {
  UserPoolId: string | undefined;
  Identifier: string | undefined;
}
export interface DeleteUserRequest {
  AccessToken: string | undefined;
}
export interface DeleteUserAttributesRequest {
  UserAttributeNames: string[] | undefined;
  AccessToken: string | undefined;
}
export interface DeleteUserAttributesResponse {}
export interface DeleteUserPoolRequest {
  UserPoolId: string | undefined;
}
export interface DeleteUserPoolClientRequest {
  UserPoolId: string | undefined;
  ClientId: string | undefined;
}
export interface DeleteUserPoolDomainRequest {
  Domain: string | undefined;
  UserPoolId: string | undefined;
}
export interface DeleteUserPoolDomainResponse {}
export interface DescribeIdentityProviderRequest {
  UserPoolId: string | undefined;
  ProviderName: string | undefined;
}
export interface DescribeIdentityProviderResponse {
  IdentityProvider: IdentityProviderType | undefined;
}
export interface DescribeResourceServerRequest {
  UserPoolId: string | undefined;
  Identifier: string | undefined;
}
export interface DescribeResourceServerResponse {
  ResourceServer: ResourceServerType | undefined;
}
export interface DescribeRiskConfigurationRequest {
  UserPoolId: string | undefined;
  ClientId?: string;
}
export declare const CompromisedCredentialsEventActionType: {
  readonly BLOCK: "BLOCK";
  readonly NO_ACTION: "NO_ACTION";
};
export type CompromisedCredentialsEventActionType =
  (typeof CompromisedCredentialsEventActionType)[keyof typeof CompromisedCredentialsEventActionType];
export interface CompromisedCredentialsActionsType {
  EventAction: CompromisedCredentialsEventActionType | undefined;
}
export declare const EventFilterType: {
  readonly PASSWORD_CHANGE: "PASSWORD_CHANGE";
  readonly SIGN_IN: "SIGN_IN";
  readonly SIGN_UP: "SIGN_UP";
};
export type EventFilterType =
  (typeof EventFilterType)[keyof typeof EventFilterType];
export interface CompromisedCredentialsRiskConfigurationType {
  EventFilter?: EventFilterType[];
  Actions: CompromisedCredentialsActionsType | undefined;
}
export interface RiskExceptionConfigurationType {
  BlockedIPRangeList?: string[];
  SkippedIPRangeList?: string[];
}
export interface RiskConfigurationType {
  UserPoolId?: string;
  ClientId?: string;
  CompromisedCredentialsRiskConfiguration?: CompromisedCredentialsRiskConfigurationType;
  AccountTakeoverRiskConfiguration?: AccountTakeoverRiskConfigurationType;
  RiskExceptionConfiguration?: RiskExceptionConfigurationType;
  LastModifiedDate?: Date;
}
export interface DescribeRiskConfigurationResponse {
  RiskConfiguration: RiskConfigurationType | undefined;
}
export interface DescribeUserImportJobRequest {
  UserPoolId: string | undefined;
  JobId: string | undefined;
}
export interface DescribeUserImportJobResponse {
  UserImportJob?: UserImportJobType;
}
export interface DescribeUserPoolRequest {
  UserPoolId: string | undefined;
}
export interface DescribeUserPoolResponse {
  UserPool?: UserPoolType;
}
export interface DescribeUserPoolClientRequest {
  UserPoolId: string | undefined;
  ClientId: string | undefined;
}
export interface DescribeUserPoolClientResponse {
  UserPoolClient?: UserPoolClientType;
}
export interface DescribeUserPoolDomainRequest {
  Domain: string | undefined;
}
export declare const DomainStatusType: {
  readonly ACTIVE: "ACTIVE";
  readonly CREATING: "CREATING";
  readonly DELETING: "DELETING";
  readonly FAILED: "FAILED";
  readonly UPDATING: "UPDATING";
};
export type DomainStatusType =
  (typeof DomainStatusType)[keyof typeof DomainStatusType];
export interface DomainDescriptionType {
  UserPoolId?: string;
  AWSAccountId?: string;
  Domain?: string;
  S3Bucket?: string;
  CloudFrontDistribution?: string;
  Version?: string;
  Status?: DomainStatusType;
  CustomDomainConfig?: CustomDomainConfigType;
}
export interface DescribeUserPoolDomainResponse {
  DomainDescription?: DomainDescriptionType;
}
export interface ForgetDeviceRequest {
  AccessToken?: string;
  DeviceKey: string | undefined;
}
export interface ForgotPasswordRequest {
  ClientId: string | undefined;
  SecretHash?: string;
  UserContextData?: UserContextDataType;
  Username: string | undefined;
  AnalyticsMetadata?: AnalyticsMetadataType;
  ClientMetadata?: Record<string, string>;
}
export interface CodeDeliveryDetailsType {
  Destination?: string;
  DeliveryMedium?: DeliveryMediumType;
  AttributeName?: string;
}
export interface ForgotPasswordResponse {
  CodeDeliveryDetails?: CodeDeliveryDetailsType;
}
export interface GetCSVHeaderRequest {
  UserPoolId: string | undefined;
}
export interface GetCSVHeaderResponse {
  UserPoolId?: string;
  CSVHeader?: string[];
}
export interface GetDeviceRequest {
  DeviceKey: string | undefined;
  AccessToken?: string;
}
export interface GetDeviceResponse {
  Device: DeviceType | undefined;
}
export interface GetGroupRequest {
  GroupName: string | undefined;
  UserPoolId: string | undefined;
}
export interface GetGroupResponse {
  Group?: GroupType;
}
export interface GetIdentityProviderByIdentifierRequest {
  UserPoolId: string | undefined;
  IdpIdentifier: string | undefined;
}
export interface GetIdentityProviderByIdentifierResponse {
  IdentityProvider: IdentityProviderType | undefined;
}
export interface GetLogDeliveryConfigurationRequest {
  UserPoolId: string | undefined;
}
export interface CloudWatchLogsConfigurationType {
  LogGroupArn?: string;
}
export declare const EventSourceName: {
  readonly USER_AUTH_EVENTS: "userAuthEvents";
  readonly USER_NOTIFICATION: "userNotification";
};
export type EventSourceName =
  (typeof EventSourceName)[keyof typeof EventSourceName];
export interface FirehoseConfigurationType {
  StreamArn?: string;
}
export declare const LogLevel: {
  readonly ERROR: "ERROR";
  readonly INFO: "INFO";
};
export type LogLevel = (typeof LogLevel)[keyof typeof LogLevel];
export interface S3ConfigurationType {
  BucketArn?: string;
}
export interface LogConfigurationType {
  LogLevel: LogLevel | undefined;
  EventSource: EventSourceName | undefined;
  CloudWatchLogsConfiguration?: CloudWatchLogsConfigurationType;
  S3Configuration?: S3ConfigurationType;
  FirehoseConfiguration?: FirehoseConfigurationType;
}
export interface LogDeliveryConfigurationType {
  UserPoolId: string | undefined;
  LogConfigurations: LogConfigurationType[] | undefined;
}
export interface GetLogDeliveryConfigurationResponse {
  LogDeliveryConfiguration?: LogDeliveryConfigurationType;
}
export interface GetSigningCertificateRequest {
  UserPoolId: string | undefined;
}
export interface GetSigningCertificateResponse {
  Certificate?: string;
}
export interface GetUICustomizationRequest {
  UserPoolId: string | undefined;
  ClientId?: string;
}
export interface UICustomizationType {
  UserPoolId?: string;
  ClientId?: string;
  ImageUrl?: string;
  CSS?: string;
  CSSVersion?: string;
  LastModifiedDate?: Date;
  CreationDate?: Date;
}
export interface GetUICustomizationResponse {
  UICustomization: UICustomizationType | undefined;
}
export interface GetUserRequest {
  AccessToken: string | undefined;
}
export interface GetUserResponse {
  Username: string | undefined;
  UserAttributes: AttributeType[] | undefined;
  MFAOptions?: MFAOptionType[];
  PreferredMfaSetting?: string;
  UserMFASettingList?: string[];
}
export interface GetUserAttributeVerificationCodeRequest {
  AccessToken: string | undefined;
  AttributeName: string | undefined;
  ClientMetadata?: Record<string, string>;
}
export interface GetUserAttributeVerificationCodeResponse {
  CodeDeliveryDetails?: CodeDeliveryDetailsType;
}
export interface GetUserPoolMfaConfigRequest {
  UserPoolId: string | undefined;
}
export interface SmsMfaConfigType {
  SmsAuthenticationMessage?: string;
  SmsConfiguration?: SmsConfigurationType;
}
export interface SoftwareTokenMfaConfigType {
  Enabled?: boolean;
}
export interface GetUserPoolMfaConfigResponse {
  SmsMfaConfiguration?: SmsMfaConfigType;
  SoftwareTokenMfaConfiguration?: SoftwareTokenMfaConfigType;
  MfaConfiguration?: UserPoolMfaType;
}
export interface GlobalSignOutRequest {
  AccessToken: string | undefined;
}
export interface GlobalSignOutResponse {}
export interface InitiateAuthRequest {
  AuthFlow: AuthFlowType | undefined;
  AuthParameters?: Record<string, string>;
  ClientMetadata?: Record<string, string>;
  ClientId: string | undefined;
  AnalyticsMetadata?: AnalyticsMetadataType;
  UserContextData?: UserContextDataType;
}
export interface InitiateAuthResponse {
  ChallengeName?: ChallengeNameType;
  Session?: string;
  ChallengeParameters?: Record<string, string>;
  AuthenticationResult?: AuthenticationResultType;
}
export interface ListDevicesRequest {
  AccessToken: string | undefined;
  Limit?: number;
  PaginationToken?: string;
}
export interface ListDevicesResponse {
  Devices?: DeviceType[];
  PaginationToken?: string;
}
export interface ListGroupsRequest {
  UserPoolId: string | undefined;
  Limit?: number;
  NextToken?: string;
}
export interface ListGroupsResponse {
  Groups?: GroupType[];
  NextToken?: string;
}
export interface ListIdentityProvidersRequest {
  UserPoolId: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface ProviderDescription {
  ProviderName?: string;
  ProviderType?: IdentityProviderTypeType;
  LastModifiedDate?: Date;
  CreationDate?: Date;
}
export interface ListIdentityProvidersResponse {
  Providers: ProviderDescription[] | undefined;
  NextToken?: string;
}
export interface ListResourceServersRequest {
  UserPoolId: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface ListResourceServersResponse {
  ResourceServers: ResourceServerType[] | undefined;
  NextToken?: string;
}
export interface ListTagsForResourceRequest {
  ResourceArn: string | undefined;
}
export interface ListTagsForResourceResponse {
  Tags?: Record<string, string>;
}
export interface ListUserImportJobsRequest {
  UserPoolId: string | undefined;
  MaxResults: number | undefined;
  PaginationToken?: string;
}
export interface ListUserImportJobsResponse {
  UserImportJobs?: UserImportJobType[];
  PaginationToken?: string;
}
export interface ListUserPoolClientsRequest {
  UserPoolId: string | undefined;
  MaxResults?: number;
  NextToken?: string;
}
export interface UserPoolClientDescription {
  ClientId?: string;
  UserPoolId?: string;
  ClientName?: string;
}
export interface ListUserPoolClientsResponse {
  UserPoolClients?: UserPoolClientDescription[];
  NextToken?: string;
}
export interface ListUserPoolsRequest {
  NextToken?: string;
  MaxResults: number | undefined;
}
export interface UserPoolDescriptionType {
  Id?: string;
  Name?: string;
  LambdaConfig?: LambdaConfigType;
  Status?: StatusType;
  LastModifiedDate?: Date;
  CreationDate?: Date;
}
export interface ListUserPoolsResponse {
  UserPools?: UserPoolDescriptionType[];
  NextToken?: string;
}
export interface ListUsersRequest {
  UserPoolId: string | undefined;
  AttributesToGet?: string[];
  Limit?: number;
  PaginationToken?: string;
  Filter?: string;
}
export interface ListUsersResponse {
  Users?: UserType[];
  PaginationToken?: string;
}
export interface ListUsersInGroupRequest {
  UserPoolId: string | undefined;
  GroupName: string | undefined;
  Limit?: number;
  NextToken?: string;
}
export interface ListUsersInGroupResponse {
  Users?: UserType[];
  NextToken?: string;
}
export interface ResendConfirmationCodeRequest {
  ClientId: string | undefined;
  SecretHash?: string;
  UserContextData?: UserContextDataType;
  Username: string | undefined;
  AnalyticsMetadata?: AnalyticsMetadataType;
  ClientMetadata?: Record<string, string>;
}
export interface ResendConfirmationCodeResponse {
  CodeDeliveryDetails?: CodeDeliveryDetailsType;
}
export interface RespondToAuthChallengeRequest {
  ClientId: string | undefined;
  ChallengeName: ChallengeNameType | undefined;
  Session?: string;
  ChallengeResponses?: Record<string, string>;
  AnalyticsMetadata?: AnalyticsMetadataType;
  UserContextData?: UserContextDataType;
  ClientMetadata?: Record<string, string>;
}
export interface RespondToAuthChallengeResponse {
  ChallengeName?: ChallengeNameType;
  Session?: string;
  ChallengeParameters?: Record<string, string>;
  AuthenticationResult?: AuthenticationResultType;
}
export interface RevokeTokenRequest {
  Token: string | undefined;
  ClientId: string | undefined;
  ClientSecret?: string;
}
export declare const AdminAddUserToGroupRequestFilterSensitiveLog: (
  obj: AdminAddUserToGroupRequest
) => any;
export declare const AdminConfirmSignUpRequestFilterSensitiveLog: (
  obj: AdminConfirmSignUpRequest
) => any;
export declare const AttributeTypeFilterSensitiveLog: (
  obj: AttributeType
) => any;
export declare const AdminCreateUserRequestFilterSensitiveLog: (
  obj: AdminCreateUserRequest
) => any;
export declare const UserTypeFilterSensitiveLog: (obj: UserType) => any;
export declare const AdminCreateUserResponseFilterSensitiveLog: (
  obj: AdminCreateUserResponse
) => any;
export declare const AdminDeleteUserRequestFilterSensitiveLog: (
  obj: AdminDeleteUserRequest
) => any;
export declare const AdminDeleteUserAttributesRequestFilterSensitiveLog: (
  obj: AdminDeleteUserAttributesRequest
) => any;
export declare const AdminDisableUserRequestFilterSensitiveLog: (
  obj: AdminDisableUserRequest
) => any;
export declare const AdminEnableUserRequestFilterSensitiveLog: (
  obj: AdminEnableUserRequest
) => any;
export declare const AdminForgetDeviceRequestFilterSensitiveLog: (
  obj: AdminForgetDeviceRequest
) => any;
export declare const AdminGetDeviceRequestFilterSensitiveLog: (
  obj: AdminGetDeviceRequest
) => any;
export declare const DeviceTypeFilterSensitiveLog: (obj: DeviceType) => any;
export declare const AdminGetDeviceResponseFilterSensitiveLog: (
  obj: AdminGetDeviceResponse
) => any;
export declare const AdminGetUserRequestFilterSensitiveLog: (
  obj: AdminGetUserRequest
) => any;
export declare const AdminGetUserResponseFilterSensitiveLog: (
  obj: AdminGetUserResponse
) => any;
export declare const AdminInitiateAuthRequestFilterSensitiveLog: (
  obj: AdminInitiateAuthRequest
) => any;
export declare const AuthenticationResultTypeFilterSensitiveLog: (
  obj: AuthenticationResultType
) => any;
export declare const AdminInitiateAuthResponseFilterSensitiveLog: (
  obj: AdminInitiateAuthResponse
) => any;
export declare const AdminListDevicesRequestFilterSensitiveLog: (
  obj: AdminListDevicesRequest
) => any;
export declare const AdminListDevicesResponseFilterSensitiveLog: (
  obj: AdminListDevicesResponse
) => any;
export declare const AdminListGroupsForUserRequestFilterSensitiveLog: (
  obj: AdminListGroupsForUserRequest
) => any;
export declare const AdminListUserAuthEventsRequestFilterSensitiveLog: (
  obj: AdminListUserAuthEventsRequest
) => any;
export declare const AdminRemoveUserFromGroupRequestFilterSensitiveLog: (
  obj: AdminRemoveUserFromGroupRequest
) => any;
export declare const AdminResetUserPasswordRequestFilterSensitiveLog: (
  obj: AdminResetUserPasswordRequest
) => any;
export declare const AdminRespondToAuthChallengeRequestFilterSensitiveLog: (
  obj: AdminRespondToAuthChallengeRequest
) => any;
export declare const AdminRespondToAuthChallengeResponseFilterSensitiveLog: (
  obj: AdminRespondToAuthChallengeResponse
) => any;
export declare const AdminSetUserMFAPreferenceRequestFilterSensitiveLog: (
  obj: AdminSetUserMFAPreferenceRequest
) => any;
export declare const AdminSetUserPasswordRequestFilterSensitiveLog: (
  obj: AdminSetUserPasswordRequest
) => any;
export declare const AdminSetUserSettingsRequestFilterSensitiveLog: (
  obj: AdminSetUserSettingsRequest
) => any;
export declare const AdminUpdateAuthEventFeedbackRequestFilterSensitiveLog: (
  obj: AdminUpdateAuthEventFeedbackRequest
) => any;
export declare const AdminUpdateDeviceStatusRequestFilterSensitiveLog: (
  obj: AdminUpdateDeviceStatusRequest
) => any;
export declare const AdminUpdateUserAttributesRequestFilterSensitiveLog: (
  obj: AdminUpdateUserAttributesRequest
) => any;
export declare const AdminUserGlobalSignOutRequestFilterSensitiveLog: (
  obj: AdminUserGlobalSignOutRequest
) => any;
export declare const AssociateSoftwareTokenRequestFilterSensitiveLog: (
  obj: AssociateSoftwareTokenRequest
) => any;
export declare const AssociateSoftwareTokenResponseFilterSensitiveLog: (
  obj: AssociateSoftwareTokenResponse
) => any;
export declare const ChangePasswordRequestFilterSensitiveLog: (
  obj: ChangePasswordRequest
) => any;
export declare const ConfirmDeviceRequestFilterSensitiveLog: (
  obj: ConfirmDeviceRequest
) => any;
export declare const UserContextDataTypeFilterSensitiveLog: (
  obj: UserContextDataType
) => any;
export declare const ConfirmForgotPasswordRequestFilterSensitiveLog: (
  obj: ConfirmForgotPasswordRequest
) => any;
export declare const ConfirmSignUpRequestFilterSensitiveLog: (
  obj: ConfirmSignUpRequest
) => any;
export declare const UserPoolClientTypeFilterSensitiveLog: (
  obj: UserPoolClientType
) => any;
export declare const CreateUserPoolClientResponseFilterSensitiveLog: (
  obj: CreateUserPoolClientResponse
) => any;
export declare const DeleteUserRequestFilterSensitiveLog: (
  obj: DeleteUserRequest
) => any;
export declare const DeleteUserAttributesRequestFilterSensitiveLog: (
  obj: DeleteUserAttributesRequest
) => any;
export declare const DeleteUserPoolClientRequestFilterSensitiveLog: (
  obj: DeleteUserPoolClientRequest
) => any;
export declare const DescribeRiskConfigurationRequestFilterSensitiveLog: (
  obj: DescribeRiskConfigurationRequest
) => any;
export declare const RiskConfigurationTypeFilterSensitiveLog: (
  obj: RiskConfigurationType
) => any;
export declare const DescribeRiskConfigurationResponseFilterSensitiveLog: (
  obj: DescribeRiskConfigurationResponse
) => any;
export declare const DescribeUserPoolClientRequestFilterSensitiveLog: (
  obj: DescribeUserPoolClientRequest
) => any;
export declare const DescribeUserPoolClientResponseFilterSensitiveLog: (
  obj: DescribeUserPoolClientResponse
) => any;
export declare const ForgetDeviceRequestFilterSensitiveLog: (
  obj: ForgetDeviceRequest
) => any;
export declare const ForgotPasswordRequestFilterSensitiveLog: (
  obj: ForgotPasswordRequest
) => any;
export declare const GetDeviceRequestFilterSensitiveLog: (
  obj: GetDeviceRequest
) => any;
export declare const GetDeviceResponseFilterSensitiveLog: (
  obj: GetDeviceResponse
) => any;
export declare const GetUICustomizationRequestFilterSensitiveLog: (
  obj: GetUICustomizationRequest
) => any;
export declare const UICustomizationTypeFilterSensitiveLog: (
  obj: UICustomizationType
) => any;
export declare const GetUICustomizationResponseFilterSensitiveLog: (
  obj: GetUICustomizationResponse
) => any;
export declare const GetUserRequestFilterSensitiveLog: (
  obj: GetUserRequest
) => any;
export declare const GetUserResponseFilterSensitiveLog: (
  obj: GetUserResponse
) => any;
export declare const GetUserAttributeVerificationCodeRequestFilterSensitiveLog: (
  obj: GetUserAttributeVerificationCodeRequest
) => any;
export declare const GlobalSignOutRequestFilterSensitiveLog: (
  obj: GlobalSignOutRequest
) => any;
export declare const InitiateAuthRequestFilterSensitiveLog: (
  obj: InitiateAuthRequest
) => any;
export declare const InitiateAuthResponseFilterSensitiveLog: (
  obj: InitiateAuthResponse
) => any;
export declare const ListDevicesRequestFilterSensitiveLog: (
  obj: ListDevicesRequest
) => any;
export declare const ListDevicesResponseFilterSensitiveLog: (
  obj: ListDevicesResponse
) => any;
export declare const UserPoolClientDescriptionFilterSensitiveLog: (
  obj: UserPoolClientDescription
) => any;
export declare const ListUserPoolClientsResponseFilterSensitiveLog: (
  obj: ListUserPoolClientsResponse
) => any;
export declare const ListUsersResponseFilterSensitiveLog: (
  obj: ListUsersResponse
) => any;
export declare const ListUsersInGroupResponseFilterSensitiveLog: (
  obj: ListUsersInGroupResponse
) => any;
export declare const ResendConfirmationCodeRequestFilterSensitiveLog: (
  obj: ResendConfirmationCodeRequest
) => any;
export declare const RespondToAuthChallengeRequestFilterSensitiveLog: (
  obj: RespondToAuthChallengeRequest
) => any;
export declare const RespondToAuthChallengeResponseFilterSensitiveLog: (
  obj: RespondToAuthChallengeResponse
) => any;
export declare const RevokeTokenRequestFilterSensitiveLog: (
  obj: RevokeTokenRequest
) => any;
