
const express = require('express');
const cors = require('cors');
const path = require('path');
const dotenv = require('dotenv');
const runQueries = require("./Database/Create_Tables/CreateTables.js");
const { authenticateToken } = require('./Controllers/validate_request.js');
const Database = require('./db.js');

dotenv.config();

const port = process.env.PORT;

let isDBSetup = false;

const app = express();

// app.use(cors({
//   origin: ['http://localhost:5173', 'http://localhost:5174'], // Allow these origins
//   credentials: true // Allow credentials (cookies, auth headers)
// }));

const dynamicCors = async (req, callback) => {
  const origin = req.header('Origin');
    callback(null, { origin: true, credentials: true });
};

app.use(cors(dynamicCors));

app.use(express.json());
app.use(express.urlencoded({ extended: false }));

app.use('/public/assets', express.static(path.join(__dirname, 'public/server_images')));

app.use("/api/v1/verifyLogin", require('./Controllers/login.js'));
app.use("/api/v1/verifyLogout", require('./Controllers/logout.js'));

app.use("/api/v1/country_list", require('./routes/country_state_city/countries.js'));
app.use("/api/v1/state_list", require('./routes/country_state_city/states.js'));
app.use("/api/v1/city_list", require('./routes/country_state_city/cities.js'));

app.use("/api/v1/users", require("./routes/users/users.js"));
// app.use("/api/v1/users", authenticateToken, require("./routes/users/users.js"));
app.use("/api/v1/app", require("./routes/apps/apps.js"));
// app.use("/api/v1/app", authenticateToken, require("./routes/apps/apps.js"));
app.use("/api/v1/user_role", require("./routes/user_role/user_role.js"));

app.use("/activity_log", require("./routes/activity_log/activity_log.js"));

const database = new Database();

const initializeDatabase = async () => {
  try {
    await database.testConnection();
    // console.log('Database connection established.');

    if (isDBSetup === false) {
      await runQueries();
      isDBSetup = true;
      console.log('DB setup successful.');
    }
  } catch (err) {
    console.error('Database connection/setup error:', err.message);
    throw err;
  }
};

const startServer = async () => {
  try {
    await initializeDatabase();
    
    // Start the server only if database connection is successful
    const server = app.listen(port, () => {
      console.log("Server Listening on PORT:", port);
    });

    server.on('error', (err) => {
      if (err.code === 'EADDRINUSE') {
        console.error(`Port ${port} is already in use. Please use a different port.`);
      } else {
        console.error('Server error:', err.message);
      }
    });
  } catch (err) {
    console.error('Failed to start server:', err.message);
    process.exit(1); 
  }
};


startServer();

