
const express = require('express');
const { authenticateUser } = require('./authenticate');
const { successResponse, errorResponse, executeQuery } = require('../utils/utils');
const { refreshAuthToken } = require('./validate_request');
const { Login_Table } = require('../Database/Table_Names/TB_Name_Collection');

const router = express.Router();

const saveAccessToken = async (username, AccessToken, RefreshToken) => {
    const query = `
        INSERT INTO ${Login_Table} (username, access_token, refresh_token, is_login) 
        VALUES (?, ?, ?, ?) 
        ON DUPLICATE KEY UPDATE access_token = ?, refresh_token = ?, is_login = ?`;

    const params = [username, AccessToken, RefreshToken, 1, AccessToken, RefreshToken, 1];
    
    return await executeQuery(query, params);
};


router.post("/", async (req, res) => {
    const { username, password } = req.body;

    try {
        const authResult = await authenticateUser(username, password);

        const accessToken = authResult.AccessToken;
        const refreshToken = authResult.RefreshToken;

        const result = await saveAccessToken(username, accessToken, refreshToken);

        if (!result || result.affectedRows === 0) return errorResponse(res, 400, "Failed to save information");

        res.cookie('accessToken', accessToken, {
            httpOnly: false,
            secure: true, // Use true in production for HTTPS
            maxAge: 3600 * 1000, // 1 hour expiry
            // domain: 'http://localhost:5173',
            path: '/', // cookie is accessible on all routes
            sameSite: 'None', 
        });
        res.cookie('refreshToken', refreshToken, {
            httpOnly: false,
            secure: true, // Use true in production for HTTPS
            maxAge: 30 * 24 * 60 * 60 * 1000, // 30 days expiry
            // domain: 'http://localhost:5173',
            path: '/', // cookie is accessible on all routes
            sameSite: 'None', 
        });

        return successResponse(res,"Login Successfull", authResult)
    } catch (error) {
        console.log(error)
        return errorResponse(res,500,"Internal Server Error");
    }
})

router.post("/refresh_token", async (req, res) => {
    const { username, refresh_token } = req.body;

    try {
        const refreshedToken = await refreshAuthToken(refresh_token, res);

        if (!refreshedToken || refreshedToken.error) return;

        const result = await saveAccessToken(username, refreshedToken.AccessToken, refresh_token);

        if (!result || result instanceof Error) return errorResponse(res, 400, "Failed to save information");

        return successResponse(res, "Token refreshed successfully", refreshedToken);

    } catch (error) {
        console.log("Server error", error);
        return errorResponse(res, 500, "Internal server error");
    }
});

module.exports = router;
