import React, { useEffect, useState } from 'react'
import classNames from 'classnames'
import { Link } from 'react-router-dom'
import { Card } from '@/components/ui'
import { HiOutlineClipboardCheck } from 'react-icons/hi'
import GridItem from './GridItem'
import useCustomToastify from '@/utils/customHook/useCustomToastify'
import { useDispatch } from 'react-redux'
import { setAppListReducer } from '@/store/slices/customeSlices/appList'
import { useAppSelector } from '@/store'
import { setFilterAppListReducer } from '@/store/slices/customeSlices/filterAppList'

export type AppDataType = {
    app_id: string,
    name: string,
    picture: string,
    app_url: string
}
const ProjectListContent = () => {
    const  {appList}  = useAppSelector((state) => state.appList.appList)
    const  {filterAppList}  = useAppSelector((state) => state.filterAppList.filterAppList)
    const {searchingText}=useAppSelector((state)=>state.filterAppList.filterAppList)

    const customToast = useCustomToastify()
    const [Appdata, setData] = useState<AppDataType[]>([])
    const dispatch=useDispatch()

    
    useEffect(() => {
        getAppList()
    }, [])

    useEffect(()=>{
        if(appList.length>0){
            // dispatch(setFilterAppListReducer(appList))
        }
    },[appList])

    const getAppList: any = async () => {
        try {
            const api = await fetch(`${import.meta.env.VITE_BASE_API_URL}/app/get-app-list`, {
                method: 'GET',
            })
            const response = await api.json()
            if (!response.error) {
                setData(response.data.result)
                dispatch(setAppListReducer(response.data.result))
                dispatch(setFilterAppListReducer(response.data.result))
            }else{
                customToast.danger(response.message)
            }

        } catch (error) {
            console.error("Get App list API ERROR :", error)
        }
    }
    return (
       <>
       {/* <h1>All Projets</h1> */}
        <div
            className={classNames(
                'h-full flex flex-col md:px-10 items-center  '
            )}
        >
            {
                filterAppList.length>0 ?   <div className="grid grid-cols-1 lg:grid-cols-3 xl:grid-cols-4 gap-6">
                {
                 filterAppList.map((items:any,index:number)=>{
                      return(<GridItem key={index}  projects={items} />)
                  })
                }
              </div>
              :
              <>
              <h1>No APP's</h1>
              </>
            }
          
        </div>
       </>
    )
}

export default ProjectListContent