import {createSlice,PayloadAction} from '@reduxjs/toolkit'

export type filterAppListState = {
    filterAppList:{
        app_id: string
        name: string
        picture: string
        app_url: string
    }[],
    searchingText:string,
}
const initialState : filterAppListState={
    filterAppList:[],
    searchingText:''
}

const filteredAppListSlice=createSlice({
    name:'filteredAppList',
    initialState,
    reducers:{
        setFilterAppListReducer:(state:any,action: PayloadAction<filterAppListState['filterAppList']>)=>{
            state.filterAppList=action.payload
        },
        setSearchingText:(state:any,action:PayloadAction<filterAppListState['searchingText']>)=>{
            state.searchingText=action.payload
        }
    }
})

export const {setFilterAppListReducer,setSearchingText}=filteredAppListSlice.actions
export default filteredAppListSlice