import { lazy } from 'react'
import { APP_PREFIX_PATH } from '@/constants/route.constant'
import { ADMIN, USER } from '@/constants/roles.constant'
import type { Routes } from '@/@types/routes'

const appsRoute: Routes = [
    {
        key: 'appsCrm.dashboard',
        path: `${APP_PREFIX_PATH}/dashboard`,
        component: lazy(() => import('@/views/crm/CrmDashboard')),
        authority: [ADMIN, USER],
    },
    {
        key: 'appsCrm.add_apps',
        path: `${APP_PREFIX_PATH}/addApps`,
        component: lazy(() => import('@/views/apps/addApps')),
        authority: [ADMIN, USER],
    },
    {
        key: 'appsCrm.all_apps',
        path: `${APP_PREFIX_PATH}/allApps`,
        component: lazy(() => import('@/views/apps/viewApps')),
        authority: [ADMIN, USER],
    },
    {
        key: 'appsCrm.update_apps',
        path: `${APP_PREFIX_PATH}/allApps/update/:id`,
        component: lazy(() => import('@/views/apps/updateApp')),
        authority: [ADMIN, USER],
    },
    {
        key: 'appsProject.projectList',
        path: `${APP_PREFIX_PATH}/portal`,
        component: lazy(() => import('@/views/portal/portal-dashboard')),
        authority: [ADMIN, USER],
    },
]

export default appsRoute
